/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;

public class GlobalModuleDependencyProcessor
implements DeploymentUnitProcessor {
    private volatile ModelNode globalModules = new ModelNode();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModelNode globalMods = this.globalModules;
        if (globalMods.isDefined()) {
            for (ModelNode module : globalMods.asList()) {
                String name = module.get("name").asString();
                String slot = module.hasDefined("slot") ? module.get("slot").asString() : "main";
                ModuleIdentifier identifier = ModuleIdentifier.create((String)name, (String)slot);
                moduleSpecification.addSystemDependency(new ModuleDependency(Module.getBootModuleLoader(), identifier, false, false, true, false));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    public void setGlobalModules(ModelNode globalModules) {
        this.globalModules = globalModules;
    }
}

