/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalModulesDefinition
extends ListAttributeDefinition {
    public static final String NAME = "name";
    public static final String SLOT = "slot";
    public static final String GLOBAL_MODULES = "global-modules";
    private static final ParameterValidator moduleValidator;
    public static final String DEFAULT_SLOT = "main";
    public static final GlobalModulesDefinition INSTANCE;

    private GlobalModulesDefinition() {
        super(GLOBAL_MODULES, true, moduleValidator);
    }

    public ModelNode resolveModelAttribute(OperationContext context, ModelNode operationObject) throws OperationFailedException {
        ModelNode result = super.validateOperation(operationObject);
        if (result.isDefined()) {
            for (ModelNode module : result.asList()) {
                if (module.hasDefined(SLOT)) continue;
                module.get(SLOT).set(DEFAULT_SLOT);
            }
        }
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        throw EeMessages.MESSAGES.resourceDescriptionResolverError();
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{NAME, "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{NAME}));
        valueType.get(new String[]{SLOT, "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{SLOT}));
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{NAME, "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{NAME}));
        valueType.get(new String[]{SLOT, "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{SLOT}));
    }

    public void marshallAsElement(ModelNode eeSubSystem, boolean marshalDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (eeSubSystem.hasDefined(this.getName()) && eeSubSystem.asInt() > 0) {
            writer.writeStartElement(Element.GLOBAL_MODULES.getLocalName());
            ModelNode globalModules = eeSubSystem.get(this.getName());
            for (ModelNode module : globalModules.asList()) {
                writer.writeEmptyElement(Element.MODULE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), module.get(NAME).asString());
                if (!module.hasDefined(SLOT)) continue;
                writer.writeAttribute(Attribute.SLOT.getLocalName(), module.get(SLOT).asString());
            }
            writer.writeEndElement();
        }
    }

    private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
        ModelNode valueType = parent.get("value-type");
        ModelNode name = valueType.get(NAME);
        name.get("description");
        name.get("type").set(ModelType.STRING);
        name.get("nillable").set(false);
        ModelNode slot = valueType.get(SLOT);
        slot.get("description");
        slot.get("type").set(ModelType.STRING);
        slot.get("nillable").set(true);
        slot.get("default").set(DEFAULT_SLOT);
        return valueType;
    }

    static {
        ParametersValidator delegate = new ParametersValidator();
        delegate.registerValidator(NAME, (ParameterValidator)new StringLengthValidator(1));
        delegate.registerValidator(SLOT, (ParameterValidator)new StringLengthValidator(1, true));
        moduleValidator = new ParametersOfValidator(delegate);
        INSTANCE = new GlobalModulesDefinition();
    }
}

