/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.NamespaceConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.PopulatingMap;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponentDescription
extends ComponentDescription {
    private TransactionAttributeType beanTransactionAttribute = TransactionAttributeType.REQUIRED;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private final Map<MethodIntf, TransactionAttributeType> txPerViewStyle1 = new HashMap<MethodIntf, TransactionAttributeType>();
    private final PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>> txPerViewStyle2 = new PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>>(){

        @Override
        Map<String, TransactionAttributeType> populate() {
            return new HashMap<String, TransactionAttributeType>();
        }
    };
    private final PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txPerViewStyle3 = new PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };
    private final Map<String, TransactionAttributeType> txStyle2 = new HashMap<String, TransactionAttributeType>();
    private final PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> txStyle3 = new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

        @Override
        Map<ArrayKey, TransactionAttributeType> populate() {
            return new HashMap<ArrayKey, TransactionAttributeType>();
        }
    };

    public EJBComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription.getEEModuleDescription(), ejbJarDescription.getEEModuleDescription().getOrAddClassByName(componentClassName), deploymentUnitServiceName);
        if (ejbJarDescription.isWar()) {
            this.setNamingMode(ComponentNamingMode.USE_MODULE);
        } else {
            this.setNamingMode(ComponentNamingMode.CREATE);
        }
        this.getConfigurators().addFirst(new NamespaceConfigurator());
        this.getConfigurators().add(new EjbJarConfigurationConfigurator());
        this.addDependency(EJBUtilities.SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
        this.addCurrentInvocationContextFactory();
    }

    private static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public TransactionAttributeType getTransactionAttribute(MethodIntf methodIntf, String methodName, String ... methodParams) {
        assert (methodIntf != null) : "methodIntf is null";
        assert (methodName != null) : "methodName is null";
        assert (methodParams != null) : "methodParams is null";
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        TransactionAttributeType txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle3, methodIntf), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle2, methodIntf), methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txPerViewStyle1, methodIntf);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txStyle3, methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle2, methodName);
        if (txAttr != null) {
            return txAttr;
        }
        return this.beanTransactionAttribute;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public abstract MethodIntf getMethodIntf(String var1);

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute) {
        if (methodIntf == null) {
            this.beanTransactionAttribute = transactionAttribute;
        } else {
            this.txPerViewStyle1.put(methodIntf, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName) {
        if (methodIntf == null) {
            this.txStyle2.put(methodName, transactionAttribute);
        } else {
            this.txPerViewStyle2.pick(methodIntf).put(methodName, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName, String ... methodParams) {
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        if (methodIntf == null) {
            this.txStyle3.pick(methodName).put(methodParamsKey, transactionAttribute);
        } else {
            this.txPerViewStyle3.pick(methodIntf).pick(methodName).put(methodParamsKey, transactionAttribute);
        }
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void setupViewInterceptors(ViewDescription view) {
        this.addCurrentInvocationContextFactory(view);
    }

    protected void setupClientViewInterceptors(ViewDescription view) {
        this.addToStringMethodInterceptor(view);
    }

    protected abstract void addCurrentInvocationContextFactory();

    protected abstract void addCurrentInvocationContextFactory(ViewDescription var1);

    private void addToStringMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                Method[] methods;
                Method TO_STRING_METHOD;
                try {
                    TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new DeploymentUnitProcessingException((Throwable)nsme);
                }
                for (Method method : methods = configuration.getProxyFactory().getCachedMethods()) {
                    if (!TO_STRING_METHOD.equals(method)) continue;
                    Deque clientInterceptorsForMethod = configuration.getClientInterceptorDeque(method);
                    clientInterceptorsForMethod.addFirst(new ImmediateInterceptorFactory((Interceptor)new ToStringMethodInterceptor()));
                    return;
                }
            }
        });
    }

    private class ToStringMethodInterceptor
    implements Interceptor {
        private ToStringMethodInterceptor() {
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentViewInstance componentViewInstance = (ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class);
            if (componentViewInstance == null) {
                throw new IllegalStateException("ComponentViewInstance not available in interceptor context: " + context);
            }
            return "Proxy for view class: " + componentViewInstance.getViewClass().getName() + " of EJB: " + EJBComponentDescription.this.getComponentName();
        }
    }

    private class EjbJarConfigurationConfigurator
    implements ComponentConfigurator {
        private EjbJarConfigurationConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            EjbJarConfiguration ejbJarConfiguration = (EjbJarConfiguration)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_CONFIGURATION);
            if (ejbJarConfiguration == null) {
                throw new DeploymentUnitProcessingException("EjbJarConfiguration not found as an attachment in deployment unit: " + deploymentUnit);
            }
            EJBComponentCreateServiceFactory ejbComponentCreateServiceFactory = (EJBComponentCreateServiceFactory)configuration.getComponentCreateServiceFactory();
            ejbComponentCreateServiceFactory.setEjbJarConfiguration(ejbJarConfiguration);
        }
    }
}

