/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.util.Arrays;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class EJBMethodDescription {
    private String methodName;
    private String[] methodParamTypes;
    private MethodIntf viewType;
    private int hashCode;

    public EJBMethodDescription(MethodInfo methodInfo) {
        if (methodInfo == null) {
            throw new IllegalArgumentException("MethodInfo cannot be null");
        }
        this.methodName = methodInfo.name();
        this.viewType = MethodIntf.BEAN;
        String[] params = this.toString(methodInfo.args());
        this.methodParamTypes = params == null ? new String[]{} : params;
    }

    public EJBMethodDescription(String methodName, String ... methodParamTypes) {
        this(MethodIntf.BEAN, methodName, methodParamTypes);
    }

    public EJBMethodDescription(MethodIntf view, String methodName, String ... paramTypes) {
        if (methodName == null) {
            throw new IllegalArgumentException("Method name cannot be null");
        }
        this.methodName = methodName;
        this.methodParamTypes = paramTypes == null ? new String[]{} : paramTypes;
        this.viewType = view == null ? MethodIntf.BEAN : view;
        this.hashCode = this.generateHashCode();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParams() {
        return this.methodParamTypes;
    }

    public MethodIntf getViewType() {
        return this.viewType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EJBMethodDescription that = (EJBMethodDescription)o;
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.methodParamTypes, that.methodParamTypes)) {
            return false;
        }
        return this.viewType == that.viewType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.methodParamTypes);
        result = 31 * result + this.viewType.hashCode();
        return result;
    }

    private String[] toString(Type[] types) {
        if (types == null) {
            return null;
        }
        String[] result = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i].toString();
        }
        return result;
    }
}

