/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentConfiguration;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;

public abstract class SessionBeanComponentConfiguration
extends EJBComponentConfiguration {
    private LockType beanLevelLockType;
    private AccessTimeout beanLevelAccessTimeout;
    private Map<EJBBusinessMethod, LockType> methodLevelLockTypes;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;
    private final Set<Method> asynchronousMethods = Collections.newSetFromMap(new IdentityHashMap());

    public SessionBeanComponentConfiguration(SessionBeanComponentDescription description, EEModuleClassConfiguration ejbClassConfiguration) {
        super(description, ejbClassConfiguration);
        this.beanLevelAccessTimeout = description.getBeanLevelAccessTimeout();
        if (description.allowsConcurrentAccess()) {
            this.beanLevelLockType = description.getBeanLevelLockType();
            if (description.getConcurrencyManagementType() != ConcurrencyManagementType.BEAN) {
                // empty if block
            }
        }
    }

    @Override
    protected void addCurrentInvocationContextInterceptorFactory() {
    }

    public LockType getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public AccessTimeout getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public Map<EJBBusinessMethod, LockType> getMethodApplicableLockTypes() {
        return this.methodLevelLockTypes;
    }

    public Map<EJBBusinessMethod, AccessTimeout> getMethodApplicableAccessTimeouts() {
        return this.methodAccessTimeouts;
    }

    protected void setMethodApplicableAccessTimeout(Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts) {
        this.methodAccessTimeouts = methodAccessTimeouts;
    }

    protected void setMethodApplicableLockType(Map<EJBBusinessMethod, LockType> methodLockTypes) {
        this.methodLevelLockTypes = methodLockTypes;
    }

    public Set<Method> getAsynchronousMethods() {
        return this.asynchronousMethods;
    }

    public void addAsynchronousMethod(Method method) {
        this.asynchronousMethods.add(method);
    }
}

