/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.PrimitiveClassLoaderUtil;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBMethodDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentConfiguration;
import org.jboss.as.ejb3.component.session.SessionInvocationContextInterceptor;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class SessionBeanComponentDescription
extends EJBComponentDescription {
    private static final Logger logger = Logger.getLogger(SessionBeanComponentDescription.class);
    private boolean noInterfaceViewPresent;
    private Map<String, MethodIntf> viewTypes = new HashMap<String, MethodIntf>();
    private ConcurrencyManagementType concurrencyManagementType;
    private LockType beanLevelLockType;
    private AccessTimeout beanLevelAccessTimeout;
    private Map<EJBMethodDescription, LockType> methodLockTypes = new ConcurrentHashMap<EJBMethodDescription, LockType>();
    private Map<EJBMethodDescription, AccessTimeout> methodAccessTimeouts = new ConcurrentHashMap<EJBMethodDescription, AccessTimeout>();
    private final Set<MethodIdentifier> asynchronousMethods = new HashSet<MethodIdentifier>();
    private final Set<String> asynchronousViews = new HashSet<String>();
    private String mappedName;

    public SessionBeanComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
        this.addDependency(SessionBeanComponent.ASYNC_EXECUTOR_SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
    }

    public abstract boolean allowsConcurrentAccess();

    public void addLocalBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            if (this.viewTypes.get(viewClassName) == MethodIntf.REMOTE) {
                throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as local view since it's already marked as remote view for bean: " + this.getEJBName());
            }
            this.viewTypes.put(viewClassName, MethodIntf.LOCAL);
            ViewDescription viewDescription = new ViewDescription((ComponentDescription)this, viewClassName);
            this.getViews().add(viewDescription);
            this.setupViewInterceptors(viewDescription);
            this.setupClientViewInterceptors(viewDescription);
        }
    }

    public void addLocalBusinessInterfaceViews(String ... classNames) {
        this.addLocalBusinessInterfaceViews(Arrays.asList(classNames));
    }

    public void addNoInterfaceView() {
        this.noInterfaceViewPresent = true;
        this.viewTypes.put(this.getEJBClassName(), MethodIntf.LOCAL);
        ViewDescription viewDescription = new ViewDescription((ComponentDescription)this, this.getEJBClassName());
        this.getViews().add(viewDescription);
        this.setupViewInterceptors(viewDescription);
        this.setupClientViewInterceptors(viewDescription);
    }

    public void addRemoteBusinessInterfaceViews(Collection<String> classNames) {
        for (String viewClassName : classNames) {
            if (this.viewTypes.get(viewClassName) == MethodIntf.LOCAL) {
                throw new IllegalStateException("[EJB 3.1 spec, section 4.9.7] - Can't add view class: " + viewClassName + " as remote view since it's already marked as local view for bean: " + this.getEJBName());
            }
            this.viewTypes.put(viewClassName, MethodIntf.REMOTE);
            ViewDescription viewDescription = new ViewDescription((ComponentDescription)this, viewClassName);
            this.getViews().add(viewDescription);
            this.setupViewInterceptors(viewDescription);
            this.setupClientViewInterceptors(viewDescription);
        }
    }

    @Override
    public MethodIntf getMethodIntf(String viewClassName) {
        MethodIntf methodIntf = this.viewTypes.get(viewClassName);
        assert (methodIntf != null) : "no view type known for " + viewClassName;
        return methodIntf;
    }

    public boolean hasNoInterfaceView() {
        return this.noInterfaceViewPresent;
    }

    public void setBeanLevelLockType(LockType locktype) {
        if (this.beanLevelLockType != null && this.beanLevelLockType != locktype) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelLockType + " lock type. Cannot change it to " + locktype);
        }
        this.beanLevelLockType = locktype;
    }

    public LockType getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public void setLockType(LockType lockType, EJBMethodDescription method) {
        this.methodLockTypes.put(method, lockType);
    }

    public AccessTimeout getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public void setBeanLevelAccessTimeout(AccessTimeout accessTimeout) {
        if (this.beanLevelAccessTimeout != null && this.beanLevelAccessTimeout != accessTimeout) {
            throw new IllegalArgumentException(this.getEJBName() + " bean has already been marked for " + this.beanLevelAccessTimeout + " access timeout. Cannot change it to " + accessTimeout);
        }
        this.beanLevelAccessTimeout = accessTimeout;
    }

    public void setAccessTimeout(AccessTimeout accessTimeout, EJBMethodDescription method) {
        this.methodAccessTimeouts.put(method, accessTimeout);
    }

    public ConcurrencyManagementType getConcurrencyManagementType() {
        return this.concurrencyManagementType;
    }

    public void beanManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.BEAN) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.BEAN;
    }

    public void containerManagedConcurrency() {
        if (this.concurrencyManagementType != null && this.concurrencyManagementType != ConcurrencyManagementType.CONTAINER) {
            throw new IllegalStateException(this.getEJBName() + " bean has been marked for " + this.concurrencyManagementType + " cannot change it now!");
        }
        this.concurrencyManagementType = ConcurrencyManagementType.CONTAINER;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void addAsynchronousMethod(MethodIdentifier methodIdentifier) {
        this.asynchronousMethods.add(methodIdentifier);
    }

    public void addAsynchronousView(String viewName) {
        this.asynchronousViews.add(viewName);
    }

    public abstract SessionBeanType getSessionBeanType();

    private void prepareAccessTimeoutConfiguration(SessionBeanComponentConfiguration sessionBeanComponentConfiguration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ClassLoader beanClassLoader = sessionBeanComponentConfiguration.getComponentClass().getClassLoader();
        HashMap<EJBBusinessMethod, AccessTimeout> methodApplicableAccessTimeouts = new HashMap<EJBBusinessMethod, AccessTimeout>();
        for (Map.Entry<EJBMethodDescription, AccessTimeout> entry : this.methodAccessTimeouts.entrySet()) {
            EJBMethodDescription method = entry.getKey();
            try {
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(method, beanClassLoader);
                methodApplicableAccessTimeouts.put(ejbMethod, entry.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeploymentUnitProcessingException("Could not process @AccessTimeout configurations due to exception: ", (Throwable)cnfe);
            }
        }
        sessionBeanComponentConfiguration.setMethodApplicableAccessTimeout(methodApplicableAccessTimeouts);
    }

    private void prepareLockConfiguration(SessionBeanComponentConfiguration sessionBeanComponentConfiguration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ClassLoader beanClassLoader = sessionBeanComponentConfiguration.getComponentClass().getClassLoader();
        HashMap<EJBBusinessMethod, LockType> methodApplicableLockTypes = new HashMap<EJBBusinessMethod, LockType>();
        for (Map.Entry<EJBMethodDescription, LockType> entry : this.methodLockTypes.entrySet()) {
            EJBMethodDescription method = entry.getKey();
            try {
                EJBBusinessMethod ejbMethod = this.getEJBBusinessMethod(method, beanClassLoader);
                methodApplicableLockTypes.put(ejbMethod, entry.getValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeploymentUnitProcessingException("Could not process LockType configurations due to exception: ", (Throwable)cnfe);
            }
        }
        sessionBeanComponentConfiguration.setMethodApplicableLockType(methodApplicableLockTypes);
    }

    private EJBBusinessMethod getEJBBusinessMethod(EJBMethodDescription method, ClassLoader classLoader) throws ClassNotFoundException {
        String methodName = method.getMethodName();
        String[] types = method.getMethodParams();
        if (types == null || types.length == 0) {
            return new EJBBusinessMethod(methodName, new Class[0]);
        }
        Class[] paramTypes = new Class[types.length];
        int i = 0;
        for (String type : types) {
            paramTypes[i++] = PrimitiveClassLoaderUtil.loadClass(type.toString(), classLoader);
        }
        return new EJBBusinessMethod(methodName, paramTypes);
    }

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        this.addTxManagementInterceptorForView(view);
    }

    protected void addTxManagementInterceptorForView(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
                if (TransactionManagementType.CONTAINER.equals((Object)ejbComponentDescription.getTransactionManagementType())) {
                    configuration.addViewInterceptorToFront((InterceptorFactory)new ComponentInterceptorFactory(){

                        protected Interceptor create(Component component, InterceptorFactoryContext context) {
                            if (!(component instanceof TransactionalComponent)) {
                                throw new IllegalArgumentException("Component " + component + " with component class: " + component.getComponentClass() + " isn't a transactional component. Tx interceptors cannot be applied");
                            }
                            return new CMTTxInterceptor((TransactionalComponent)component);
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getPostConstructInterceptors().addFirst(new ImmediateInterceptorFactory((Interceptor)new SessionInvocationContextInterceptor()));
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptorToFront((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new SessionInvocationContextInterceptor()));
            }
        });
    }

    public static enum SessionBeanType {
        STATELESS,
        STATEFUL,
        SINGLETON;

    }
}

