/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentConfiguration;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonBMTInterceptor;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstanceAssociationInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class SingletonComponentConfiguration
extends SessionBeanComponentConfiguration {
    private boolean initOnStartup;

    public SingletonComponentConfiguration(SingletonComponentDescription description) {
        super((SessionBeanComponentDescription)description);
        this.initOnStartup = description.isInitOnStartup();
        this.addComponentSystemInterceptorFactory((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new SingletonComponentInstanceAssociationInterceptor()));
        if (TransactionManagementType.BEAN.equals((Object)description.getTransactionManagementType())) {
            this.addComponentSystemInterceptorFactory((InterceptorFactory)new ComponentInterceptorFactory(){

                protected Interceptor create(Component component, InterceptorFactoryContext context) {
                    return new SingletonBMTInterceptor((SingletonComponent)component);
                }
            });
        }
    }

    public AbstractComponent constructComponent() {
        return new SingletonComponent(this);
    }

    public boolean isInitOnStartup() {
        return this.initOnStartup;
    }
}

