/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.Remote;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class BusinessViewAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final DotName LOCAL = DotName.createSimple((String)Local.class.getName());
    private static final DotName LOCAL_BEAN = DotName.createSimple((String)LocalBean.class.getName());
    private static final DotName REMOTE = DotName.createSimple((String)Remote.class.getName());
    private static final Logger logger = Logger.getLogger(BusinessViewAnnotationProcessor.class);

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo sessionBeanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription sessionBeanComponentDescription) throws DeploymentUnitProcessingException {
        Collection<String> remoteBusinessInterfaces = BusinessViewAnnotationProcessor.getBusinessInterfaces(sessionBeanClass, compositeIndex, REMOTE);
        sessionBeanComponentDescription.addRemoteBusinessInterfaceViews(remoteBusinessInterfaces);
        Collection<String> localBusinessInterfaces = BusinessViewAnnotationProcessor.getBusinessInterfaces(sessionBeanClass, compositeIndex, LOCAL);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Session bean: " + sessionBeanComponentDescription.getEJBName() + " has " + localBusinessInterfaces.size() + " local business interfaces namely: " + localBusinessInterfaces));
        }
        sessionBeanComponentDescription.addLocalBusinessInterfaceViews(localBusinessInterfaces);
        if (BusinessViewAnnotationProcessor.hasNoInterfaceView(sessionBeanClass)) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (BusinessViewAnnotationProcessor.hasNoViews(sessionBeanComponentDescription)) {
            Set<DotName> names = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (names.isEmpty()) {
                sessionBeanComponentDescription.addNoInterfaceView();
            } else if (names.size() == 1) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(names.iterator().next().toString());
            }
        }
    }

    private static Collection<String> getBusinessInterfaces(ClassInfo sessionBeanClass, CompositeIndex compositeIndex, DotName annotationType) throws DeploymentUnitProcessingException {
        Type[] interfaceTypes;
        Map annotationsOnBean = sessionBeanClass.annotations();
        List annotations = (List)annotationsOnBean.get(annotationType);
        if (annotations == null || annotations.isEmpty()) {
            Collection<String> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, compositeIndex, annotationType);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        if (annotations.size() > 1) {
            throw new DeploymentUnitProcessingException("@" + annotationType + " appears more than once in EJB class: " + sessionBeanClass.name());
        }
        AnnotationInstance annotation = (AnnotationInstance)annotations.get(0);
        AnnotationTarget target = annotation.target();
        if (!(target instanceof ClassInfo)) {
            throw new RuntimeException("@" + annotationType + " should only appear on a class. Target: " + target + " is not a class");
        }
        AnnotationValue annotationValue = annotation.value();
        if (annotationValue == null) {
            Set<DotName> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1) {
                throw new DeploymentUnitProcessingException("Bean " + sessionBeanClass + " specifies @" + annotationType + ", but does not implement 1 interface");
            }
            return Collections.singleton(interfaces.iterator().next().toString());
        }
        HashSet<String> businessInterfaces = new HashSet<String>();
        for (Type type : interfaceTypes = annotationValue.asClassArray()) {
            businessInterfaces.add(type.name().toString());
        }
        return businessInterfaces;
    }

    private static Collection<String> getBusinessInterfacesFromInterfaceAnnotations(ClassInfo sessionBeanClass, CompositeIndex compositeIndex, DotName annotationType) {
        Set<DotName> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
        HashSet<String> localInterfaces = new HashSet<String>();
        block0: for (DotName iface : interfaces) {
            ClassInfo ifaceClass = compositeIndex.getClassByName(iface);
            if (ifaceClass != null) {
                List annotations = (List)ifaceClass.annotations().get(annotationType);
                if (annotations == null) continue;
                for (AnnotationInstance annotation : annotations) {
                    if (!(annotation.target() instanceof ClassInfo)) continue;
                    localInterfaces.add(iface.toString());
                    continue block0;
                }
                continue;
            }
            logger.warnf("Could not read annotations on EJB interface %s", (Object)iface.toString());
        }
        return localInterfaces;
    }

    private static String getDefaultLocalInterface(ClassInfo sessionBeanClass, CompositeIndex index) {
        Set<DotName> names = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
        if (names.size() != 1) {
            return null;
        }
        DotName iface = names.iterator().next();
        ClassInfo classInfo = index.getClassByName(iface);
        if (classInfo == null) {
            logger.warnf("Could not read annotations in interface %s when determining local interfaces for %s", (Object)iface, (Object)sessionBeanClass.name());
            return null;
        }
        List annotations = (List)classInfo.annotations().get(REMOTE);
        if (annotations == null || annotations.isEmpty()) {
            return iface.toString();
        }
        for (AnnotationInstance annotation : annotations) {
            if (!(annotation.target() instanceof ClassInfo)) continue;
            return null;
        }
        return iface.toString();
    }

    private static Set<DotName> getPotentialBusinessInterfaces(ClassInfo sessionBeanClass) {
        DotName[] interfaces = sessionBeanClass.interfaces();
        if (interfaces == null) {
            return Collections.emptySet();
        }
        HashSet<DotName> names = new HashSet<DotName>();
        for (DotName dotName : interfaces) {
            String name = dotName.toString();
            if (name.equals(Serializable.class.getName()) || name.equals(Externalizable.class.getName()) || name.startsWith("javax.ejb.")) continue;
            names.add(dotName);
        }
        return names;
    }

    private static boolean hasNoInterfaceView(ClassInfo sessionBeanClass) {
        Map annotationsOnBeanClass = sessionBeanClass.annotations();
        if (annotationsOnBeanClass == null || annotationsOnBeanClass.isEmpty()) {
            return false;
        }
        List localBeanAnnotations = (List)annotationsOnBeanClass.get(LOCAL_BEAN);
        return localBeanAnnotations != null && !localBeanAnnotations.isEmpty();
    }

    private static boolean hasNoViews(SessionBeanComponentDescription sessionBeanComponentDescription) {
        return sessionBeanComponentDescription.getViews() == null || sessionBeanComponentDescription.getViews().isEmpty();
    }
}

