/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewBindingInjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class EjbJndiBindingsDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EjbJndiBindingsDeploymentUnitProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            this.setupJNDIBindings((SessionBeanComponentDescription)componentDescription, deploymentUnit);
        }
    }

    private void setupJNDIBindings(SessionBeanComponentDescription sessionBean, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        List views = sessionBean.getViews();
        if (views == null || views.isEmpty()) {
            logger.info((Object)("No jndi bindings will be created for EJB: " + sessionBean.getEJBName() + " since no views are exposed"));
            return;
        }
        String applicationName = this.getEarName(deploymentUnit);
        String globalJNDIBaseName = "java:global/" + (applicationName != null ? applicationName + "/" : "") + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String appJNDIBaseName = "java:app/" + sessionBean.getModuleName() + "/" + sessionBean.getEJBName();
        String moduleJNDIBaseName = "java:module/" + sessionBean.getEJBName();
        ServiceName baseServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{sessionBean.getComponentName()});
        StringBuilder jndiBindingsLogMessage = new StringBuilder();
        jndiBindingsLogMessage.append("JNDI bindings for session bean named " + sessionBean.getEJBName() + " in deployment unit " + deploymentUnit + " are as follows:\n\n");
        for (ViewDescription viewDescription : views) {
            String viewClassName = viewDescription.getViewClassName();
            String globalJNDIName = globalJNDIBaseName + "!" + viewClassName;
            ViewBindingInjectionSource globalBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration globalBinding = new BindingConfiguration(globalJNDIName, (InjectionSource)globalBindingSource);
            this.addBindingConfiguration(viewDescription, globalBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(globalJNDIName);
            jndiBindingsLogMessage.append("\n");
            String appJNDIName = appJNDIBaseName + "!" + viewClassName;
            ViewBindingInjectionSource appBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration appBinding = new BindingConfiguration(appJNDIName, (InjectionSource)appBindingSource);
            this.addBindingConfiguration(viewDescription, appBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(appJNDIName);
            jndiBindingsLogMessage.append("\n");
            String moduleJNDIName = moduleJNDIBaseName + "!" + viewClassName;
            ViewBindingInjectionSource moduleBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration moduleBinding = new BindingConfiguration(moduleJNDIName, (InjectionSource)moduleBindingSource);
            this.addBindingConfiguration(viewDescription, moduleBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(moduleJNDIName);
            jndiBindingsLogMessage.append("\n");
        }
        if (views.size() == 1) {
            ViewDescription viewDescription = (ViewDescription)views.get(0);
            String viewClassName = viewDescription.getViewClassName();
            ViewBindingInjectionSource globalBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration globalBinding = new BindingConfiguration(globalJNDIBaseName, (InjectionSource)globalBindingSource);
            this.addBindingConfiguration(viewDescription, globalBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(globalJNDIBaseName);
            jndiBindingsLogMessage.append("\n");
            ViewBindingInjectionSource appBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration appBinding = new BindingConfiguration(appJNDIBaseName, (InjectionSource)appBindingSource);
            this.addBindingConfiguration(viewDescription, appBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(appJNDIBaseName);
            jndiBindingsLogMessage.append("\n");
            ViewBindingInjectionSource moduleBindingSource = new ViewBindingInjectionSource(baseServiceName.append(new String[]{"VIEW"}).append(new String[]{viewClassName}));
            BindingConfiguration moduleBinding = new BindingConfiguration(moduleJNDIBaseName, (InjectionSource)moduleBindingSource);
            this.addBindingConfiguration(viewDescription, moduleBinding);
            jndiBindingsLogMessage.append("\t");
            jndiBindingsLogMessage.append(moduleJNDIBaseName);
            jndiBindingsLogMessage.append("\n");
        }
        logger.info((Object)jndiBindingsLogMessage);
    }

    private String getEarName(DeploymentUnit deploymentUnit) {
        DeploymentUnit parentDU = deploymentUnit.getParent();
        if (parentDU == null) {
            String duName = deploymentUnit.getName();
            if (duName.endsWith(".ear")) {
                return duName.substring(0, duName.length() - ".ear".length());
            }
            return null;
        }
        while (parentDU.getParent() != null) {
            parentDU = parentDU.getParent();
        }
        String duName = parentDU.getName();
        if (duName.endsWith(".ear")) {
            return duName.substring(0, duName.length() - ".ear".length());
        }
        return null;
    }

    private void addBindingConfiguration(ViewDescription viewDescription, final BindingConfiguration bindingConfiguration) {
        viewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
    }

    public void undeploy(DeploymentUnit context) {
    }
}

