/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.beans.IntrospectionException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.security.ServerSecurityManager;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.inflow.EndpointDeployer;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.jca.core.spi.rar.MessageListener;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.util.propertyeditor.PropertyEditors;

public class EJBUtilities
implements EndpointDeployer,
Service<EJBUtilities> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "utilities"});
    private final InjectedValue<ResourceAdapterRepository> resourceAdapterRepositoryValue = new InjectedValue();
    private final InjectedValue<ServerSecurityManager> securityManagerValue = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerValue = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryValue = new InjectedValue();
    private final InjectedValue<UserTransaction> userTransactionValue = new InjectedValue();
    private volatile boolean statisticsEnabled = false;

    @Override
    public ActivationSpec createActivationSpecs(String resourceAdapterName, Class<?> messageListenerInterface, Properties activationConfigProperties, ClassLoader classLoader) {
        try {
            String raIdentifier = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)resourceAdapterName);
            if (raIdentifier == null) {
                throw EjbMessages.MESSAGES.unknownResourceAdapter(resourceAdapterName);
            }
            ResourceAdapterRepository resourceAdapterRepository = this.getResourceAdapterRepository();
            if (resourceAdapterRepository == null) {
                throw EjbLogger.EJB3_LOGGER.resourceAdapterRepositoryUnAvailable();
            }
            List messageListeners = resourceAdapterRepository.getMessageListeners(raIdentifier);
            if (messageListeners == null || messageListeners.isEmpty()) {
                throw EjbMessages.MESSAGES.unknownMessageListenerType(messageListenerInterface.getName(), resourceAdapterName);
            }
            MessageListener requiredMessageListener = null;
            for (MessageListener messageListener : messageListeners) {
                if (!messageListenerInterface.equals(messageListener.getType())) continue;
                requiredMessageListener = messageListener;
                break;
            }
            if (requiredMessageListener == null) {
                throw EjbMessages.MESSAGES.unknownMessageListenerType(messageListenerInterface.getName(), resourceAdapterName);
            }
            Activation activation = requiredMessageListener.getActivation();
            Properties validActivationConfigProps = this.filterUnknownActivationConfigProperties(resourceAdapterName, activation, activationConfigProperties);
            ActivationSpec activationSpec = activation.createInstance();
            PropertyEditors.mapJavaBeanProperties((Object)activationSpec, (Properties)validActivationConfigProps);
            return activationSpec;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public Endpoint getEndpoint(String resourceAdapterName) {
        String raIdentifier = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)resourceAdapterName);
        if (raIdentifier == null) {
            throw EjbMessages.MESSAGES.unknownResourceAdapter(resourceAdapterName);
        }
        ResourceAdapterRepository resourceAdapterRepository = this.getResourceAdapterRepository();
        if (resourceAdapterRepository == null) {
            throw EjbLogger.EJB3_LOGGER.resourceAdapterRepositoryUnAvailable();
        }
        try {
            return resourceAdapterRepository.getEndpoint(raIdentifier);
        }
        catch (NotFoundException nfe) {
            throw EjbLogger.EJB3_LOGGER.noSuchEndpointException(resourceAdapterName, nfe);
        }
    }

    public ResourceAdapterRepository getResourceAdapterRepository() {
        return (ResourceAdapterRepository)this.resourceAdapterRepositoryValue.getOptionalValue();
    }

    public Injector<ResourceAdapterRepository> getResourceAdapterRepositoryInjector() {
        return this.resourceAdapterRepositoryValue;
    }

    public ServerSecurityManager getSecurityManager() {
        ServerSecurityManager securityManager = (ServerSecurityManager)this.securityManagerValue.getOptionalValue();
        if (securityManager == null) {
            throw EjbMessages.MESSAGES.securityNotEnabled();
        }
        return securityManager;
    }

    public Injector<ServerSecurityManager> getSecurityManagerInjector() {
        return this.securityManagerValue;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.transactionManagerValue.getOptionalValue();
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerValue;
    }

    public InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
        return this.transactionSynchronizationRegistryValue;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryValue.getOptionalValue();
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)this.userTransactionValue.getOptionalValue();
    }

    public Injector<UserTransaction> getUserTransactionInjector() {
        return this.userTransactionValue;
    }

    public EJBUtilities getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public boolean hasSecurityManager() {
        return this.securityManagerValue.getOptionalValue() != null;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean b) {
        this.statisticsEnabled = b;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    private Properties filterUnknownActivationConfigProperties(String resourceAdapterName, Activation activation, Properties activationConfigProps) {
        if (activationConfigProps == null) {
            return null;
        }
        Map raActivationConfigProps = activation.getConfigProperties();
        Set raRequiredConfigProps = activation.getRequiredConfigProperties();
        Enumeration<?> propNames = activationConfigProps.propertyNames();
        Properties validActivationConfigProps = new Properties();
        validActivationConfigProps.putAll((Map<?, ?>)activationConfigProps);
        while (propNames.hasMoreElements()) {
            Object propName = propNames.nextElement();
            if (raActivationConfigProps.containsKey(propName) || raRequiredConfigProps.contains(propName)) continue;
            validActivationConfigProps.remove(propName);
            EjbLogger.EJB3_LOGGER.activationConfigPropertyIgnored(propName, resourceAdapterName);
        }
        return validActivationConfigProps;
    }
}

