/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.invocationmetrics;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class InvocationMetrics {
    private final AtomicReference<Values> values = new AtomicReference<Values>(new Values(0L, 0L, 0L));
    private final AtomicLong concurrent = new AtomicLong(0L);
    private final AtomicLong peakConcurrent = new AtomicLong(0L);

    void finishInvocation(long invocationWaitTime, long invocationExecutionTime) {
        Values newv;
        Values oldv;
        this.concurrent.decrementAndGet();
        while (!this.values.compareAndSet(oldv = this.values.get(), newv = new Values(oldv.invocations + 1L, oldv.waitTime + invocationWaitTime, oldv.executionTime + invocationExecutionTime))) {
        }
    }

    public long getConcurrent() {
        return this.concurrent.get();
    }

    public long getExecutionTime() {
        return this.values.get().executionTime;
    }

    public long getInvocations() {
        return this.values.get().invocations;
    }

    public long getPeakConcurrent() {
        return this.peakConcurrent.get();
    }

    public long getWaitTime() {
        return this.values.get().waitTime;
    }

    void startInvocation() {
        long v = this.concurrent.incrementAndGet();
        if (this.peakConcurrent.get() < v) {
            this.peakConcurrent.incrementAndGet();
        }
    }

    private static class Values {
        final long invocations;
        final long executionTime;
        final long waitTime;

        private Values(long invocations, long waitTime, long executionTime) {
            this.invocations = invocations;
            this.executionTime = executionTime;
            this.waitTime = waitTime;
        }
    }
}

