/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.ejb3.remote.LocalEJBReceiverPreferringDeploymentNodeSelector;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelector;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.xnio.OptionMap;

public class DefaultEjbClientContextService
implements Service<EJBClientContext> {
    private static final Logger logger = Logger.getLogger(DefaultEjbClientContextService.class);
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext"});
    public static final ServiceName DEFAULT_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"default"});
    private final InjectedValue<TCCLEJBClientContextSelectorService> tcclEJBClientContextSelector = new InjectedValue();
    private final InjectedValue<LocalEjbReceiver> defaultLocalEJBReceiver = new InjectedValue();
    private volatile EJBClientContext context;
    private final boolean lockSelectorOnStart;

    public DefaultEjbClientContextService(boolean lockEJBClientContextSelectorOnStart) {
        this.lockSelectorOnStart = lockEJBClientContextSelectorOnStart;
    }

    public synchronized void start(StartContext context) throws StartException {
        EJBClientContext clientContext = EJBClientContext.create((EJBClientConfiguration)new LocalOnlyEjbClientConfiguration());
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)((Object)this.defaultLocalEJBReceiver.getOptionalValue());
        if (localEjbReceiver != null) {
            clientContext.registerEJBReceiver((EJBReceiver)localEjbReceiver);
        }
        this.context = clientContext;
        if (this.lockSelectorOnStart) {
            AccessController.doPrivileged(new LockSelectorAction());
        }
        TCCLEJBClientContextSelector.INSTANCE.setup((TCCLEJBClientContextSelectorService)this.tcclEJBClientContextSelector.getValue(), this.context);
    }

    public synchronized void stop(StopContext context) {
        this.context = null;
        TCCLEJBClientContextSelector.INSTANCE.destroy();
    }

    public EJBClientContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.context;
    }

    public Injector<TCCLEJBClientContextSelectorService> getTCCLBasedEJBClientContextSelectorInjector() {
        return this.tcclEJBClientContextSelector;
    }

    public Injector<LocalEjbReceiver> getDefaultLocalEJBReceiverInjector() {
        return this.defaultLocalEJBReceiver;
    }

    static {
        AccessController.doPrivileged(new SetSelectorAction(TCCLEJBClientContextSelector.INSTANCE));
    }

    class LocalOnlyEjbClientConfiguration
    implements EJBClientConfiguration {
        private final DeploymentNodeSelector localPreferringDeploymentNodeSelector = new LocalEJBReceiverPreferringDeploymentNodeSelector();

        LocalOnlyEjbClientConfiguration() {
        }

        public String getEndpointName() {
            return null;
        }

        public OptionMap getEndpointCreationOptions() {
            return OptionMap.EMPTY;
        }

        public OptionMap getRemoteConnectionProviderCreationOptions() {
            return OptionMap.EMPTY;
        }

        public CallbackHandler getCallbackHandler() {
            return null;
        }

        public Iterator<EJBClientConfiguration.RemotingConnectionConfiguration> getConnectionConfigurations() {
            return Collections.EMPTY_SET.iterator();
        }

        public Iterator<EJBClientConfiguration.ClusterConfiguration> getClusterConfigurations() {
            return Collections.EMPTY_SET.iterator();
        }

        public EJBClientConfiguration.ClusterConfiguration getClusterConfiguration(String nodeName) {
            return null;
        }

        public long getInvocationTimeout() {
            return 0L;
        }

        public long getReconnectTasksTimeout() {
            return 0L;
        }

        public DeploymentNodeSelector getDeploymentNodeSelector() {
            return this.localPreferringDeploymentNodeSelector;
        }
    }

    private static final class LockSelectorAction
    implements PrivilegedAction<Void> {
        private LockSelectorAction() {
        }

        @Override
        public Void run() {
            EJBClientContext.lockSelector();
            return null;
        }
    }

    private static final class SetSelectorAction
    implements PrivilegedAction<ContextSelector<EJBClientContext>> {
        private final ContextSelector<EJBClientContext> selector;

        private SetSelectorAction(ContextSelector<EJBClientContext> selector) {
            this.selector = selector;
        }

        @Override
        public ContextSelector<EJBClientContext> run() {
            return EJBClientContext.setSelector(this.selector);
        }
    }
}

