/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Timer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.deployment.processors.AroundTimeoutAnnotationParsingProcessor;
import org.jboss.as.ejb3.deployment.processors.TimerServiceDeploymentProcessor;
import org.jboss.as.ejb3.deployment.processors.annotation.TimerServiceAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.merging.TimerMethodMergingProcessor;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.ejb3.timerservice.persistence.filestore.FileTimerPersistence;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class TimerServiceAdd
extends AbstractBoottimeAddStepHandler {
    public static final TimerServiceAdd INSTANCE = new TimerServiceAdd();

    protected void populateModel(ModelNode operation, ModelNode timerServiceModel) throws OperationFailedException {
        for (AttributeDefinition attr : TimerServiceResourceDefinition.ATTRIBUTES.values()) {
            attr.validateAndSet(operation, timerServiceModel);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode pathNode = TimerServiceResourceDefinition.PATH.resolveModelAttribute(context, model);
        final String path = pathNode.isDefined() ? pathNode.asString() : null;
        ModelNode relativeToNode = TimerServiceResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        String threadPoolName = TimerServiceResourceDefinition.THREAD_POOL_NAME.resolveModelAttribute(context, model).asString();
        final ServiceName threadPoolServiceName = EJB3SubsystemModel.BASE_THREAD_POOL_SERVICE_NAME.append(new String[]{threadPoolName});
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                EjbLogger.ROOT_LOGGER.debug("Configuring timers");
                if (path != null) {
                    processorTarget.addDeploymentProcessor("ejb3", Phase.PARSE, 13313, (DeploymentUnitProcessor)new TimerServiceAnnotationProcessor());
                    processorTarget.addDeploymentProcessor("ejb3", Phase.PARSE, 13312, (DeploymentUnitProcessor)new AroundTimeoutAnnotationParsingProcessor());
                    processorTarget.addDeploymentProcessor("ejb3", Phase.POST_MODULE, 1286, (DeploymentUnitProcessor)new TimerMethodMergingProcessor());
                    processorTarget.addDeploymentProcessor("ejb3", Phase.POST_MODULE, 1537, (DeploymentUnitProcessor)new TimerServiceDeploymentProcessor(threadPoolServiceName));
                }
            }
        }, OperationContext.Stage.RUNTIME);
        newControllers.add(context.getServiceTarget().addService(TimerServiceDeploymentProcessor.TIMER_SERVICE_NAME, (Service)new TimerValueService()).install());
        FileTimerPersistence fileTimerPersistence = new FileTimerPersistence(true, path, relativeTo);
        newControllers.add(context.getServiceTarget().addService(FileTimerPersistence.SERVICE_NAME, (Service)fileTimerPersistence).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, fileTimerPersistence.getModuleLoader()).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, fileTimerPersistence.getPathManager()).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, fileTimerPersistence.getTransactionManager()).addDependency(TransactionSynchronizationRegistryService.SERVICE_NAME, TransactionSynchronizationRegistry.class, fileTimerPersistence.getTransactionSynchronizationRegistry()).install());
    }

    private static final class TimerValueService
    implements Service<Timer> {
        private Timer timer;

        private TimerValueService() {
        }

        public synchronized void start(StartContext context) throws StartException {
            this.timer = new Timer();
        }

        public synchronized void stop(StopContext context) {
            this.timer.cancel();
            this.timer = null;
        }

        public synchronized Timer getValue() throws IllegalStateException, IllegalArgumentException {
            return this.timer;
        }
    }
}

