/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentRuntimeHandler;
import org.jboss.as.ejb3.subsystem.deployment.AbstractRuntimeMetricsHandler;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.TimerAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractEJBComponentResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition COMPONENT_CLASS_NAME = new SimpleAttributeDefinitionBuilder("component-class-name", ModelType.STRING).setValidator((ParameterValidator)new StringLengthValidator(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private static final AttributeDefinition EXECUTION_TIME = new SimpleAttributeDefinitionBuilder("execution-time", ModelType.LONG).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private static final AttributeDefinition INVOCATIONS = new SimpleAttributeDefinitionBuilder("invocations", ModelType.LONG).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private static final AttributeDefinition PEAK_CONCURRENT_INVOCATIONS = new SimpleAttributeDefinitionBuilder("peak-concurrent-invocations", ModelType.LONG).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    private static final AttributeDefinition WAIT_TIME = new SimpleAttributeDefinitionBuilder("wait-time", ModelType.LONG).setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition RUN_AS_ROLE = new SimpleAttributeDefinitionBuilder("run-as-role", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final ListAttributeDefinition DECLARED_ROLES = new ListAttributeDefinition("declared-roles", true, (ParameterValidator)new StringLengthValidator(1), new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}){

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            node.get("value-type").set(ModelType.STRING);
        }

        public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            throw EjbMessages.MESSAGES.runtimeAttributeNotMarshallable(this.getName());
        }
    };
    public static final SimpleAttributeDefinition POOL_AVAILABLE_COUNT = new SimpleAttributeDefinitionBuilder("pool-available-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition POOL_CREATE_COUNT = new SimpleAttributeDefinitionBuilder("pool-create-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition POOL_CURRENT_SIZE = new SimpleAttributeDefinitionBuilder("pool-current-size", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition POOL_NAME = new SimpleAttributeDefinitionBuilder("pool-name", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition POOL_REMOVE_COUNT = new SimpleAttributeDefinitionBuilder("pool-remove-count", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    public static final SimpleAttributeDefinition POOL_MAX_SIZE = new SimpleAttributeDefinitionBuilder("pool-max-size", ModelType.INT, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME}).build();
    private final EJBComponentType componentType;

    public AbstractEJBComponentResourceDefinition(EJBComponentType componentType) {
        super(PathElement.pathElement((String)componentType.getResourceType()), EJB3Extension.getResourceDescriptionResolver(componentType.getResourceType()));
        this.componentType = componentType;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        AbstractEJBComponentRuntimeHandler<?> handler = this.componentType.getRuntimeHandler();
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)COMPONENT_CLASS_NAME, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SECURITY_DOMAIN, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RUN_AS_ROLE, handler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DECLARED_ROLES, handler);
        if (this.componentType.hasTimer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)TimerAttributeDefinition.INSTANCE, handler);
        }
        if (this.componentType.hasPool()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_AVAILABLE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_CREATE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_NAME, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_REMOVE_COUNT, handler);
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POOL_CURRENT_SIZE, handler);
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)POOL_MAX_SIZE, handler, handler);
        }
        resourceRegistration.registerMetric(EXECUTION_TIME, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) throws OperationFailedException {
                context.getResult().set(component.getInvocationMetrics().getExecutionTime());
            }
        });
        resourceRegistration.registerMetric(INVOCATIONS, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) throws OperationFailedException {
                context.getResult().set(component.getInvocationMetrics().getInvocations());
            }
        });
        resourceRegistration.registerMetric(PEAK_CONCURRENT_INVOCATIONS, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) throws OperationFailedException {
                context.getResult().set(component.getInvocationMetrics().getPeakConcurrent());
            }
        });
        resourceRegistration.registerMetric(WAIT_TIME, (OperationStepHandler)new AbstractRuntimeMetricsHandler(){

            @Override
            protected void executeReadMetricStep(OperationContext context, ModelNode operation, EJBComponent component) throws OperationFailedException {
                context.getResult().set(component.getInvocationMetrics().getWaitTime());
            }
        });
    }
}

