/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.as.embedded.ejb3.ClassPathEjbJarScanner;
import org.jboss.logging.Logger;

public class JBossStandaloneEJBContainer
extends EJBContainer {
    private static final Logger log = Logger.getLogger(JBossStandaloneEJBContainer.class);
    private final StandaloneServer server;
    private final List<File> deployments = new LinkedList<File>();
    private final List<File> tempFiles = new LinkedList<File>();

    JBossStandaloneEJBContainer(StandaloneServer server) {
        this.server = server;
    }

    public void close() {
        for (File deployment : this.deployments) {
            try {
                this.server.undeploy(deployment);
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "Failed to undeploy %s", (Object)deployment);
            }
        }
        this.server.stop();
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
    }

    void deploy(File deployment) throws IOException, ExecutionException, InterruptedException {
        this.server.deploy(deployment);
        this.deployments.add(deployment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Map<?, ?> properties) throws IOException, ExecutionException, InterruptedException {
        String[] candidates = ClassPathEjbJarScanner.getEjbJars(properties);
        if (candidates.length == 1) {
            this.deploy(new File(candidates[0]));
        } else if (candidates.length > 1) {
            File tempEar;
            if (properties.containsKey("javax.ejb.embeddable.appName")) {
                String tmpDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("java.io.tmpdir");
                    }
                });
                tempEar = new File(tmpDir + "/" + properties.get("javax.ejb.embeddable.appName") + ".ear");
            } else {
                tempEar = File.createTempFile("ejb-embedded", ".ear");
            }
            FileOutputStream out = new FileOutputStream(tempEar);
            ZipOutputStream zip = new ZipOutputStream(out);
            try {
                byte[] buf = new byte[1024];
                for (String candidate : candidates) {
                    File file = new File(candidate);
                    File zipTarget = file.isDirectory() ? JBossStandaloneEJBContainer.createTempZip(file) : file;
                    FileInputStream stream = new FileInputStream(zipTarget);
                    try {
                        int len;
                        String name = file.getName().indexOf(46) == -1 ? file.getName() + ".jar" : file.getName();
                        ZipEntry entry = new ZipEntry(name);
                        zip.putNextEntry(entry);
                        while ((len = ((InputStream)stream).read(buf)) > 0) {
                            zip.write(buf, 0, len);
                        }
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                }
                zip.flush();
            }
            finally {
                zip.close();
            }
            this.tempFiles.add(tempEar);
            this.deploy(tempEar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempZip(File file) throws IOException {
        File ret = File.createTempFile("ejbTemp", ".jar");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(ret));
        try {
            JBossStandaloneEJBContainer.zip(file, file, out);
        }
        finally {
            out.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[1024];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                JBossStandaloneEJBContainer.zip(files[i], base, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            try {
                ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
                zos.putNextEntry(entry);
                while (-1 != (read = in.read(buffer))) {
                    zos.write(buffer, 0, read);
                }
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    public Context getContext() {
        return this.server.getContext();
    }
}

