/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import javax.xml.namespace.QName;
import org.jboss.as.controller.parsing.DomainXml;
import org.jboss.as.controller.parsing.HostXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ConfigurationPersisterFactory {
    public static ExtensibleConfigurationPersister createHostXmlConfigurationPersister(File configDir, ConfigurationFile file) {
        HostXml hostXml = new HostXml(Module.getBootModuleLoader());
        return new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "host"), (XMLElementReader)hostXml, (XMLElementWriter)hostXml);
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(File configDir, ConfigurationFile file) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader());
        return new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
    }

    public static ExtensibleConfigurationPersister createCachedRemoteDomainXmlConfigurationPersister(File configDir) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader());
        File file = new File(configDir, "domain.cached-remote.xml");
        return new XmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
    }
}

