/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.process.DefaultJvmUtils;

public class HostControllerEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    public static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    public static final String DOMAIN_SYSTEM_DEPLOYMENT_DIR = "jboss.domain.system.deployment.dir";
    public static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    public static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";
    public static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private final Map<String, String> hostSystemProperties;
    private final String processName;
    private final InetAddress processControllerAddress;
    private final Integer processControllerPort;
    private final InetAddress hostControllerAddress;
    private final Integer hostControllerPort;
    private final File homeDir;
    private final File modulesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final ConfigurationFile hostConfigurationFile;
    private final ConfigurationFile domainConfigurationFile;
    private final File domainDeploymentDir;
    private final File domainSystemDeploymentDir;
    private final File domainDataDir;
    private final File domainLogDir;
    private final File domainServersDir;
    private final File domainTempDir;
    private final File defaultJVM;
    private final boolean isRestart;
    private final boolean backupDomainFiles;
    private final boolean useCachedDc;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public HostControllerEnvironment(Map<String, String> hostSystemProperties, boolean isRestart, InputStream stdin, PrintStream stdout, PrintStream stderr, String processName, InetAddress processControllerAddress, Integer processControllerPort, InetAddress hostControllerAddress, Integer hostControllerPort, String defaultJVM, String domainConfig, String hostConfig, boolean backupDomainFiles, boolean useCachedDc) {
        if (hostSystemProperties == null) {
            throw new IllegalArgumentException("hostSystemProperties is null");
        }
        this.hostSystemProperties = Collections.unmodifiableMap(hostSystemProperties);
        if (stdin == null) {
            throw new IllegalArgumentException("stdin is null");
        }
        this.stdin = stdin;
        if (stdout == null) {
            throw new IllegalArgumentException("stdout is null");
        }
        this.stdout = stdout;
        if (stderr == null) {
            throw new IllegalArgumentException("stderr is null");
        }
        this.stderr = stderr;
        if (processName == null) {
            throw new IllegalArgumentException("processName is null");
        }
        if (processControllerAddress == null) {
            throw new IllegalArgumentException("processControllerAddress is null");
        }
        if (processControllerPort == null) {
            throw new IllegalArgumentException("processControllerPort is null");
        }
        if (hostControllerAddress == null) {
            throw new IllegalArgumentException("hostControllerAddress is null");
        }
        if (hostControllerPort == null) {
            throw new IllegalArgumentException("hostControllerPort is null");
        }
        this.processName = processName;
        this.processControllerPort = processControllerPort;
        this.processControllerAddress = processControllerAddress;
        this.hostControllerAddress = hostControllerAddress;
        this.hostControllerPort = hostControllerPort;
        this.isRestart = isRestart;
        File home = this.getFileFromProperty(HOME_DIR);
        if (home == null) {
            home = new File(System.getProperty("user.dir"));
        }
        this.homeDir = home;
        System.setProperty(HOME_DIR, this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        }
        this.modulesDir = tmp;
        System.setProperty(MODULES_DIR, this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "domain");
        }
        this.domainBaseDir = tmp;
        System.setProperty(DOMAIN_BASE_DIR, this.domainBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "configuration");
        }
        this.domainConfigurationDir = tmp;
        System.setProperty(DOMAIN_CONFIG_DIR, this.domainConfigurationDir.getAbsolutePath());
        this.hostConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, "host.xml", hostConfig);
        this.domainConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, "domain.xml", domainConfig);
        tmp = this.getFileFromProperty(DOMAIN_DEPLOYMENT_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "content");
        }
        this.domainDeploymentDir = tmp;
        System.setProperty(DOMAIN_DEPLOYMENT_DIR, this.domainDeploymentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SYSTEM_DEPLOYMENT_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "system-content");
        }
        this.domainSystemDeploymentDir = tmp;
        System.setProperty(DOMAIN_DEPLOYMENT_DIR, this.domainDeploymentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_DATA_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "data");
        }
        this.domainDataDir = tmp;
        System.setProperty(DOMAIN_DATA_DIR, this.domainDataDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_LOG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "log");
        }
        this.domainLogDir = tmp;
        System.setProperty(DOMAIN_LOG_DIR, this.domainLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SERVERS_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "servers");
        }
        this.domainServersDir = tmp;
        System.setProperty(DOMAIN_SERVERS_DIR, this.domainServersDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_TEMP_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "tmp");
        }
        this.domainTempDir = tmp;
        System.setProperty(DOMAIN_TEMP_DIR, this.domainTempDir.getAbsolutePath());
        if (defaultJVM != null) {
            if (defaultJVM.equals("java")) {
                defaultJVM = DefaultJvmUtils.findJavaExecutable((String)DefaultJvmUtils.getCurrentJvmHome());
            }
            this.defaultJVM = new File(defaultJVM);
        } else {
            this.defaultJVM = null;
        }
        this.backupDomainFiles = backupDomainFiles;
        this.useCachedDc = useCachedDc;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public String getProcessName() {
        return this.processName;
    }

    public InetAddress getProcessControllerAddress() {
        return this.processControllerAddress;
    }

    public Integer getProcessControllerPort() {
        return this.processControllerPort;
    }

    public InetAddress getHostControllerAddress() {
        return this.hostControllerAddress;
    }

    public Integer getHostControllerPort() {
        return this.hostControllerPort;
    }

    public boolean isRestart() {
        return this.isRestart;
    }

    public boolean isBackupDomainFiles() {
        return this.backupDomainFiles;
    }

    public boolean isUseCachedDc() {
        return this.useCachedDc;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public File getDomainDeploymentDir() {
        return this.domainDeploymentDir;
    }

    public File getDomainSystemDeploymentDir() {
        return this.domainSystemDeploymentDir;
    }

    public File getDomainDataDir() {
        return this.domainDataDir;
    }

    public File getDomainLogDir() {
        return this.domainLogDir;
    }

    public File getDomainServersDir() {
        return this.domainServersDir;
    }

    public File getDomainTempDir() {
        return this.domainTempDir;
    }

    public File getDefaultJVM() {
        return this.defaultJVM;
    }

    public ConfigurationFile getHostConfigurationFile() {
        return this.hostConfigurationFile;
    }

    public ConfigurationFile getDomainConfigurationFile() {
        return this.domainConfigurationFile;
    }

    public Map<String, String> getHostSystemProperties() {
        return this.hostSystemProperties;
    }

    private File getFileFromProperty(String name) {
        String value = this.hostSystemProperties.get(name);
        if (value != null) {
            File f = new File(value);
            return f;
        }
        return null;
    }
}

