/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NativeManagementAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("remove");
        compensatingOperation.get("address").set(operation.require("address"));
        final String interfaceName = operation.require("interface").asString();
        final int port = operation.require("port").asInt();
        ModelNode subModel = context.getSubModel();
        subModel.get("interface").set(interfaceName);
        subModel.get("port").set(port);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    Logger.getLogger((String)"org.jboss.as").infof("creating native management service using network interface (%s) port (%s)", (Object)interfaceName, (Object)port);
                    ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"host", "controller"});
                    ServiceName threadFactoryServiceName = SERVICE_NAME_BASE.append(new String[]{"thread-factory"});
                    ServiceName executorServiceName = SERVICE_NAME_BASE.append(new String[]{"executor"});
                    ManagementCommunicationService managementCommunicationService = new ManagementCommunicationService();
                    serviceTarget.addService(ManagementCommunicationService.SERVICE_NAME, (Service)managementCommunicationService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, managementCommunicationService.getInterfaceInjector()).addInjection(managementCommunicationService.getPortInjector(), (Object)port).addDependency(executorServiceName, ExecutorService.class, managementCommunicationService.getExecutorServiceInjector()).addDependency(threadFactoryServiceName, ThreadFactory.class, managementCommunicationService.getThreadFactoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return ManagementDescription.getAddNativeManagementDescription((Locale)locale);
    }
}

