/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.host.controller.DomainModelProxy;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.LocalFileRepository;
import org.jboss.as.host.controller.operations.DomainControllerAddUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

public class RemoteDomainControllerAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-remote-domain-controller";
    private final ParametersValidator parametersValidator = new ParametersValidator();
    private final DomainModelProxy domainModelProxy;
    private final HostControllerEnvironment environment;

    public static ModelNode getAddDomainControllerOperation(ModelNode address, String host, int port) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("host").set(host);
        op.get("port").set(port);
        return op;
    }

    public static RemoteDomainControllerAddHandler getInstance(DomainModelProxy domainModelProxy, HostControllerEnvironment environment) {
        return new RemoteDomainControllerAddHandler(domainModelProxy, environment);
    }

    RemoteDomainControllerAddHandler(DomainModelProxy domainModelProxy, HostControllerEnvironment environment) {
        this.domainModelProxy = domainModelProxy;
        this.environment = environment;
        this.parametersValidator.registerValidator("port", (ParameterValidator)new IntRangeValidator(1, 65535, false, true));
        this.parametersValidator.registerValidator("host", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.parametersValidator.validate(operation);
        ModelNode model = context.getSubModel();
        model.get(new String[]{"domain-controller", "remote", "port"}).set(operation.require("port"));
        model.get(new String[]{"domain-controller", "remote", "host"}).set(operation.require("host"));
        resultHandler.handleResultComplete();
        if (context.getRuntimeContext() != null) {
            final DomainModelImpl domainModel = this.domainModelProxy.getDomainModel();
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    LocalFileRepository fileRepository = new LocalFileRepository(RemoteDomainControllerAddHandler.this.environment);
                    DomainControllerAddUtil.installRemoteDomainControllerConnection(domainModel.getHostModel(), serviceTarget, fileRepository);
                    DomainControllerAddUtil.installLocalDomainController(RemoteDomainControllerAddHandler.this.environment, domainModel.getHostModel(), serviceTarget, true, fileRepository, RemoteDomainControllerAddHandler.this.domainModelProxy.getDomainModel());
                }
            });
        }
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
        return new BasicOperationResult(compensating);
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

