/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalOperationImpl;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public abstract class ServerTaskExecutor {
    private final OperationContext context;
    private final Map<ServerIdentity, ExecutedServerRequest> submittedTasks;
    private final List<ServerPreparedResponse> preparedResults;

    protected ServerTaskExecutor(OperationContext context, Map<ServerIdentity, ExecutedServerRequest> submittedTasks, List<ServerPreparedResponse> preparedResults) {
        this.context = context;
        this.submittedTasks = submittedTasks;
        this.preparedResults = preparedResults;
    }

    protected abstract boolean execute(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> var1, ServerIdentity var2, ModelNode var3);

    public boolean executeTask(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> listener, ServerUpdateTask task) {
        return this.execute(listener, task.getServerIdentity(), task.getOperation());
    }

    protected boolean executeOperation(TransactionalProtocolClient.TransactionalOperationListener<ServerOperation> listener, TransactionalProtocolClient client, ServerIdentity identity, ModelNode operation) {
        if (client == null) {
            return false;
        }
        DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(this.context);
        DelegatingOperationAttachments operationAttachments = new DelegatingOperationAttachments(this.context);
        ServerOperation serverOperation = new ServerOperation(identity, operation, messageHandler, operationAttachments);
        try {
            AsyncFuture result = client.execute(listener, (TransactionalProtocolClient.Operation)serverOperation);
            this.recordExecutedRequest(new ExecutedServerRequest(identity, (Future<ModelNode>)result));
        }
        catch (IOException e) {
            TransactionalProtocolClient.PreparedOperation result = BlockingQueueOperationListener.FailedOperation.create((TransactionalProtocolClient.Operation)serverOperation, (Throwable)e);
            listener.operationPrepared(result);
            this.recordExecutedRequest(new ExecutedServerRequest(identity, (Future<ModelNode>)result.getFinalResult()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordExecutedRequest(ExecutedServerRequest task) {
        Map<ServerIdentity, ExecutedServerRequest> map = this.submittedTasks;
        synchronized (map) {
            this.submittedTasks.put(task.getIdentity(), task);
        }
    }

    void recordPreparedOperation(TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation) {
        this.recordPreparedTask(new ServerPreparedResponse(preparedOperation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordPreparedTask(ServerPreparedResponse task) {
        List<ServerPreparedResponse> list = this.preparedResults;
        synchronized (list) {
            this.preparedResults.add(task);
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }

    public static class ExecutedServerRequest
    implements Cancellable {
        private final ServerIdentity identity;
        private final Future<ModelNode> finalResult;

        public ExecutedServerRequest(ServerIdentity identity, Future<ModelNode> finalResult) {
            this.identity = identity;
            this.finalResult = finalResult;
        }

        public ServerIdentity getIdentity() {
            return this.identity;
        }

        public Future<ModelNode> getFinalResult() {
            return this.finalResult;
        }

        public boolean cancel() {
            return this.finalResult.cancel(false);
        }
    }

    public static class ServerPreparedResponse {
        private TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation;

        ServerPreparedResponse(TransactionalProtocolClient.PreparedOperation<ServerOperation> preparedOperation) {
            this.preparedOperation = preparedOperation;
        }

        public TransactionalProtocolClient.PreparedOperation<ServerOperation> getPreparedOperation() {
            return this.preparedOperation;
        }

        public ServerIdentity getServerIdentity() {
            return ((ServerOperation)this.preparedOperation.getOperation()).getIdentity();
        }

        public String getServerGroupName() {
            return this.getServerIdentity().getServerGroupName();
        }

        public boolean finalizeTransaction(boolean commit) {
            boolean failed = this.preparedOperation.isFailed();
            if (commit && failed) {
                return false;
            }
            if (commit) {
                this.preparedOperation.commit();
            } else if (!failed) {
                this.preparedOperation.rollback();
            }
            return true;
        }
    }

    public static class ServerOperation
    extends TransactionalOperationImpl {
        private final ServerIdentity identity;

        ServerOperation(ServerIdentity identity, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) {
            super(operation, messageHandler, attachments);
            this.identity = identity;
        }

        public ServerIdentity getIdentity() {
            return this.identity;
        }
    }

    static class ServerOperationListener
    extends BlockingQueueOperationListener<ServerOperation> {
        ServerOperationListener() {
        }

        protected void drainTo(Collection<TransactionalProtocolClient.PreparedOperation<ServerOperation>> preparedOperations) {
            super.drainTo(preparedOperations);
        }
    }
}

