/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelHandler;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.mgmt.TransformingProxyController;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFutureTask;

public class HostControllerRegistrationHandler
implements ManagementRequestHandlerFactory {
    private static final ModelNode READ_DOMAIN_MODEL = new ModelNode();
    private final ManagementChannelHandler handler;
    private final OperationExecutor operationExecutor;
    private final DomainController domainController;

    public HostControllerRegistrationHandler(ManagementChannelHandler handler, DomainController domainController, OperationExecutor operationExecutor) {
        this.handler = handler;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 81: {
                RegistrationContext context = new RegistrationContext();
                context.activeOperation = handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)context, (ActiveOperation.CompletedCallback)context);
                return new InitiateRegistrationHandler();
            }
            case 89: {
                return new RegisterSubsystemVersionsHandler();
            }
            case 88: {
                return new CompleteRegistrationHandler();
            }
        }
        return handlers.resolveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendResponse(ManagementRequestContext<RegistrationContext> context, byte responseType, ModelNode response) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            HostControllerRegistrationHandler.sendResponse(output, responseType, response);
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static void sendResponse(FlushableDataOutput output, byte responseType, ModelNode response) throws IOException {
        output.writeByte((int)responseType);
        if (response != null) {
            response.writeExternal((DataOutput)output);
        }
        output.writeByte(36);
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendFailedResponse(ManagementRequestContext<RegistrationContext> context, byte errorCode, String message) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte(34);
            output.writeByte((int)errorCode);
            output.writeUTF(message);
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static {
        READ_DOMAIN_MODEL.get("operation").set("read-master-domain-model");
        READ_DOMAIN_MODEL.get("address").setEmptyList();
        READ_DOMAIN_MODEL.protect();
    }

    static abstract class IOTask<T>
    extends AsyncFutureTask<T> {
        IOTask() {
            super(null);
        }

        abstract void sendMessage(FlushableDataOutput var1) throws IOException;

        boolean completeStep(Object result) {
            return this.setResult(result);
        }

        boolean setFailed() {
            return this.setFailed(null);
        }
    }

    class RegistrationContext
    implements ModelController.OperationTransactionControl,
    ActiveOperation.CompletedCallback<Void> {
        private String hostName;
        private ModelNode hostInfo;
        private ManagementRequestContext<RegistrationContext> responseChannel;
        private volatile IOTask<?> task;
        private volatile boolean failed;
        private volatile Transformers transformers;
        private ActiveOperation<Void, RegistrationContext> activeOperation;
        private final AtomicBoolean completed = new AtomicBoolean();

        RegistrationContext() {
        }

        protected synchronized void initialize(String hostName, ModelNode hostInfo, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.hostName = hostName;
            this.hostInfo = hostInfo;
            this.responseChannel = responseChannel;
        }

        public void completed(Void result) {
        }

        public void failed(Exception e) {
            this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
        }

        public void cancelled() {
        }

        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (this.failed) {
                transaction.rollback();
            } else {
                try {
                    this.registerHost(transaction, result);
                }
                catch (SlaveRegistrationException e) {
                    this.failed(e.getErrorCode(), e.getErrorMessage());
                }
                catch (Exception e) {
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                }
                if (this.failed) {
                    transaction.rollback();
                }
            }
        }

        protected Transformers createTransfomers(final ModelNode extensions) throws OperationFailedException {
            Transformers transformers;
            ModelNode subsystems = this.executeBlocking(new IOTask<ModelNode>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, extensions);
                }
            });
            if (this.failed) {
                throw new OperationFailedException(new ModelNode("failed to setup transformers"));
            }
            int major = this.hostInfo.get("management-major-version").asInt();
            int minor = this.hostInfo.get("management-minor-version").asInt();
            TransformationTargetImpl target = TransformationTargetImpl.create((int)major, (int)minor, (ModelNode)subsystems);
            this.transformers = transformers = Transformers.Factory.create((TransformationTarget)target);
            return transformers;
        }

        protected void setSubsystems(ModelNode resolved, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.responseChannel = responseChannel;
            this.completeTask(resolved);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerHost(ModelController.OperationTransaction transaction, final ModelNode result) throws SlaveRegistrationException {
            String productName;
            Boolean registered = this.executeBlocking(new IOTask<Boolean>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, result);
                }
            });
            if (!registered.booleanValue()) {
                transaction.rollback();
                return;
            }
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.hostName)});
                TransformingProxyController transforming = TransformingProxyController.Factory.create(HostControllerRegistrationHandler.this.handler, this.transformers, addr, ProxyOperationAddressTranslator.HOST);
                HostControllerRegistrationHandler.this.domainController.registerRemoteHost(transforming);
                if (this.failed) {
                    transaction.rollback();
                    return;
                }
                transaction.commit();
            }
            if (this.hostInfo.hasDefined("product-name")) {
                String name = this.hostInfo.get("product-name").asString();
                String version1 = this.hostInfo.get("product-version").asString();
                String version2 = this.hostInfo.get("release-version").asString();
                productName = ProductConfig.getPrettyVersionString((String)name, (String)version1, (String)version2);
            } else {
                String version1 = this.hostInfo.get("release-version").asString();
                String version2 = this.hostInfo.get("release-codename").asString();
                productName = ProductConfig.getPrettyVersionString(null, (String)version1, (String)version2);
            }
            HostControllerLogger.DOMAIN_LOGGER.registeredRemoteSlaveHost(this.hostName, productName);
        }

        void completeRegistration(ManagementRequestContext<RegistrationContext> responseChannel, boolean commit) {
            this.responseChannel = responseChannel;
            this.failed |= !commit;
            this.completeTask(!this.failed);
        }

        void failed(SlaveRegistrationException.ErrorCode errorCode, String message) {
            this.failed(errorCode.getCode(), message);
        }

        void failed(byte errorCode, String message) {
            if (this.completed.compareAndSet(false, true)) {
                this.failed = true;
                IOTask<?> task = this.task;
                if (task != null) {
                    task.setFailed();
                }
                try {
                    HostControllerRegistrationHandler.sendFailedResponse(this.responseChannel, errorCode, message);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
            }
        }

        void sendCompletedMessage() {
            if (this.completed.compareAndSet(false, true)) {
                try {
                    HostControllerRegistrationHandler.sendResponse(this.responseChannel, (byte)33, null);
                }
                catch (IOException e) {
                    ProtocolLogger.ROOT_LOGGER.debugf((Throwable)e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean completeTask(Object result) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                if (this.failed) {
                    return false;
                }
                if (this.task != null) {
                    return this.task.completeStep(result);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T executeBlocking(IOTask<T> task) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                this.task = task;
                try {
                    ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)this.responseChannel.getRequestHeader());
                    FlushableDataOutput output = this.responseChannel.writeMessage((ManagementProtocolHeader)header);
                    try {
                        task.sendMessage(output);
                    }
                    catch (IOException e) {
                        this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                        throw new IllegalStateException(e);
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
                catch (IOException e) {
                    this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
            try {
                return (T)task.get();
            }
            catch (InterruptedException e) {
                this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, e.getMessage());
                throw new IllegalStateException(e);
            }
        }
    }

    class HostRegistrationStepHandler
    implements OperationStepHandler {
        private RegistrationContext registrationContext;

        protected HostRegistrationStepHandler(RegistrationContext registrationContext) {
            this.registrationContext = registrationContext;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            boolean as711;
            context.acquireControllerLock();
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.registrationContext.hostName)) {
                String failureDescription = DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(this.registrationContext.hostName);
                this.registrationContext.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, failureDescription);
                context.getFailureDescription().set(failureDescription);
                context.completeStep();
                return;
            }
            Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode hostInfo = this.registrationContext.hostInfo;
            boolean bl = as711 = hostInfo.get("management-major-version").asInt() == 1 && hostInfo.get("management-minor-version").asInt() == 1;
            if (as711) {
                OperationFailedException failure = HostControllerMessages.MESSAGES.unsupportedManagementVersionForHost(hostInfo.get("management-major-version").asInt(), hostInfo.get("management-minor-version").asInt(), 1, 2);
                this.registrationContext.failed((Exception)failure);
                throw failure;
            }
            ModelNode extensions = new ModelNode();
            Set resources = root.getChildren("extension");
            for (Resource.ResourceEntry entry : resources) {
                extensions.add(entry.getName());
            }
            Transformers transformers = this.registrationContext.createTransfomers(extensions);
            ReadMasterDomainModelHandler handler = new ReadMasterDomainModelHandler(transformers);
            context.addStep(READ_DOMAIN_MODEL, (OperationStepHandler)handler, OperationContext.Stage.MODEL);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    static class CompleteRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        CompleteRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            String message = input.readUTF();
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.completeRegistration(context, status == 33);
        }
    }

    class RegisterSubsystemVersionsHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        RegisterSubsystemVersionsHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            ModelNode subsystems = new ModelNode();
            subsystems.readExternal(input);
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            if (status == 33) {
                registration.setSubsystems(subsystems, context);
            } else {
                registration.setSubsystems(null, context);
            }
        }
    }

    class InitiateRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        InitiateRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            final String hostName = input.readUTF();
            ModelNode hostInfo = new ModelNode();
            hostInfo.readExternal(input);
            final RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.initialize(hostName, hostInfo, context);
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(hostName)) {
                registration.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, DomainControllerMessages.MESSAGES.slaveAlreadyRegistered(hostName));
                return;
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<RegistrationContext>(){

                public void execute(ManagementRequestContext<RegistrationContext> context) throws Exception {
                    Channel channel = context.getChannel();
                    try {
                        HostRegistrationStepHandler handler = new HostRegistrationStepHandler(registration);
                        HostControllerRegistrationHandler.this.operationExecutor.execute(READ_DOMAIN_MODEL, OperationMessageHandler.logging, registration, OperationAttachments.EMPTY, handler);
                    }
                    catch (Exception e) {
                        registration.failed(e);
                        return;
                    }
                    registration.sendCompletedMessage();
                    channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(hostName)) {
                                HostControllerLogger.DOMAIN_LOGGER.lostConnectionToRemoteHost(hostName);
                            }
                            HostControllerRegistrationHandler.this.domainController.unregisterRemoteHost(hostName);
                        }
                    });
                }
            });
        }
    }

    public static interface OperationExecutor {
        public ModelNode execute(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationAttachments var4, OperationStepHandler var5);
    }
}

