/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.model.jvm.JVMDescriptions;
import org.jboss.dmr.ModelNode;

final class JVMEnvironmentVariableAddHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "add-item-to-environment-variables-list";
    static final JVMEnvironmentVariableAddHandler INSTANCE = new JVMEnvironmentVariableAddHandler();
    private final ParameterValidator validator = new StringLengthValidator(1);

    JVMEnvironmentVariableAddHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validateParameter("name", operation.get("name"));
        this.validator.validateParameter("value", operation.get("value"));
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String name = operation.require("name").asString();
        String value = operation.require("value").asString();
        ModelNode variables = model.get("environment-variables");
        if (variables.isDefined()) {
            for (ModelNode varNode : variables.asList()) {
                if (!varNode.asProperty().getName().equals(name)) continue;
                throw HostControllerMessages.MESSAGES.envVariableAlreadyExists(varNode.asProperty().getName());
            }
        }
        model.get("environment-variables").add(name, value);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JVMDescriptions.getEnvVarAddOperation(locale);
    }
}

