/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.model.jvm.JVMDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

final class JVMEnvironmentVariableRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "remove-item-from-environment-variables-list";
    static final JVMEnvironmentVariableRemoveHandler INSTANCE = new JVMEnvironmentVariableRemoveHandler();
    private final ParameterValidator validator = new StringLengthValidator(1);

    JVMEnvironmentVariableRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validateParameter("name", operation.get("name"));
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String name = operation.require("name").asString();
        ModelNode variables = model.get("environment-variables");
        if (variables.isDefined()) {
            ModelNode values = variables.clone();
            model.get("environment-variables").setEmptyList();
            for (Property value : values.asPropertyList()) {
                if (value.getName().equals(name)) continue;
                model.get("environment-variables").add(value.getName(), value.getValue());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return JVMDescriptions.getEnvVarRemoveOperation(locale);
    }
}

