/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.dmr.ModelNode;

public class ServerStatusHandler
implements OperationStepHandler {
    public static final String ATTRIBUTE_NAME = "status";
    private final ServerInventory serverInventory;

    public ServerStatusHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        String serverName = element.getValue();
        ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
        boolean isStart = subModel.hasDefined("auto-start") ? subModel.get("auto-start").asBoolean() : true;
        ServerStatus status = this.serverInventory.determineServerStatus(serverName);
        if (status == ServerStatus.STOPPED) {
            ServerStatus serverStatus = status = isStart ? status : ServerStatus.DISABLED;
        }
        if (status == null) {
            throw new OperationFailedException(new ModelNode().set(HostControllerMessages.MESSAGES.failedToGetServerStatus()));
        }
        context.getResult().set(status.toString());
        context.completeStep();
    }
}

