/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.spi.SFSBContextHandle;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

public class SFSBXPCMap {
    private static final SFSBXPCMap INSTANCE = new SFSBXPCMap();
    private ConcurrentReferenceHashMap<SFSBContextHandle, List<WeakReference<EntityManager>>> contextToXPCMap = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private ConcurrentReferenceHashMap<EntityManager, List<SFSBContextHandle>> XPCToContextMap = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private static ThreadLocal<Object[]> deferToPostConstruct = new ThreadLocal(){

        protected Object initialValue() {
            return new Object[1];
        }
    };

    public static SFSBXPCMap getINSTANCE() {
        return INSTANCE;
    }

    public List<WeakReference<EntityManager>> getXPC(SFSBContextHandle beanContextHandle) {
        return (List)this.contextToXPCMap.get((Object)beanContextHandle);
    }

    private List<SFSBContextHandle> getSFSB(EntityManager entityManager) {
        return (List)this.XPCToContextMap.get((Object)entityManager);
    }

    public static void RegisterPersistenceContext(EntityManager xpc) {
        if (xpc == null) {
            throw new RuntimeException("internal SFSBXPCMap.RegisterPersistenceContext error, null EntityManager passed in");
        }
        if (!(xpc instanceof AbstractEntityManager)) {
            throw new RuntimeException("internal error, XPC needs to be a AbstractEntityManager so that we can get metadata");
        }
        Object[] store = deferToPostConstruct.get();
        store[0] = xpc;
    }

    public void finishRegistrationOfPersistenceContext(SFSBContextHandle current) {
        Object[] store = deferToPostConstruct.get();
        if (store != null && store.length == 1) {
            if (store[0] == null) {
                throw new RuntimeException("internal SFSBXPCMap.finishRegistrationOfPersistenceContext error, null EntityManager passed in");
            }
            this.register(current, (EntityManager)store[0]);
            store[0] = null;
        }
    }

    public void register(SFSBContextHandle beanContextHandle, EntityManager entityManager) {
        if (!(entityManager instanceof AbstractEntityManager)) {
            throw new RuntimeException("internal error, XPC needs to be a AbstractEntityManager so that we can get metadata");
        }
        ArrayList<WeakReference<EntityManager>> xpcList = (ArrayList<WeakReference<EntityManager>>)this.contextToXPCMap.get((Object)beanContextHandle);
        if (xpcList == null) {
            xpcList = new ArrayList<WeakReference<EntityManager>>();
            xpcList.add(new WeakReference<EntityManager>(entityManager));
            Object existingList = this.contextToXPCMap.put((Object)beanContextHandle, xpcList);
            if (existingList != null) {
                throw new RuntimeException("More than one thread is invoking stateful session bean '" + beanContextHandle.getBeanContextHandle() + "' at the same time.");
            }
        } else {
            xpcList.add(new WeakReference<EntityManager>(entityManager));
        }
        List sfsbList = Collections.synchronizedList(new ArrayList());
        sfsbList.add(beanContextHandle);
        sfsbList = (List)this.XPCToContextMap.putIfAbsent((Object)entityManager, sfsbList);
        if (null != sfsbList) {
            sfsbList.add(beanContextHandle);
        }
    }

    public List<EntityManager> remove(SFSBContextHandle bean) {
        List result = null;
        List xpcList = (List)this.contextToXPCMap.remove((Object)bean);
        if (xpcList != null) {
            for (WeakReference xpc_ref : xpcList) {
                List sfsbList;
                EntityManager xpc = (EntityManager)xpc_ref.get();
                if (xpc == null || (sfsbList = (List)this.XPCToContextMap.get((Object)xpc)) == null) continue;
                ArrayList<SFSBContextHandle> removed = new ArrayList<SFSBContextHandle>();
                for (SFSBContextHandle beanContextHandle : sfsbList) {
                    if (beanContextHandle != bean && beanContextHandle.getBeanContextHandle() != null) continue;
                    removed.add(beanContextHandle);
                }
                sfsbList.removeAll(removed);
                if (sfsbList.size() != 0) continue;
                result.add(xpc);
            }
        }
        return result;
    }
}

