/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.injectors.PersistenceContextInjectionSource;
import org.jboss.as.jpa.injectors.PersistenceUnitInjectionSource;
import org.jboss.as.jpa.interceptor.SBInvocationInterceptor;
import org.jboss.as.jpa.interceptor.SFSBCreateInterceptorFactory;
import org.jboss.as.jpa.interceptor.SFSBDestroyInterceptorFactory;
import org.jboss.as.jpa.interceptor.SFSBInvocationInterceptor;
import org.jboss.as.jpa.processor.JPADeploymentMarker;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceName;

public class JPAAnnotationParseProcessor
implements DeploymentUnitProcessor {
    private static final DotName PERSISTENCE_CONTEXT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT_ANNOTATION_NAME = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final String ENTITY_MANAGER_CLASS = "javax.persistence.EntityManager";
    private static final String ENTITY_MANAGERFACTORY_CLASS = "javax.persistence.EntityManagerFactory";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List persistenceContexts = index.getAnnotations(PERSISTENCE_CONTEXT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceContexts);
        List persistenceUnits = index.getAnnotations(PERSISTENCE_UNIT_ANNOTATION_NAME);
        this.processPersistenceAnnotations(deploymentUnit, eeModuleDescription, persistenceUnits);
        if (!persistenceContexts.isEmpty() || !persistenceUnits.isEmpty()) {
            JPADeploymentMarker.mark(deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processPersistenceAnnotations(DeploymentUnit deploymentUnit, EEModuleDescription eeModuleDescription, List<AnnotationInstance> persistenceContexts) throws DeploymentUnitProcessingException {
        for (AnnotationInstance annotation : persistenceContexts) {
            ComponentDescription componentDescription;
            EEModuleClassDescription eeModuleClassDescription;
            ClassInfo declaringClass = null;
            AnnotationTarget annotationTarget = annotation.target();
            if (annotationTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)annotationTarget;
                declaringClass = fieldInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.getOrAddClassByName(declaringClass.name().toString());
                this.processField(deploymentUnit, annotation, fieldInfo, eeModuleClassDescription);
            } else if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                declaringClass = methodInfo.declaringClass();
                eeModuleClassDescription = eeModuleDescription.getOrAddClassByName(declaringClass.name().toString());
                this.processMethod(deploymentUnit, annotation, methodInfo, eeModuleClassDescription);
            } else if (annotationTarget instanceof ClassInfo) {
                declaringClass = (ClassInfo)annotationTarget;
                EEModuleClassDescription eeModuleClassDescription2 = eeModuleDescription.getOrAddClassByName(declaringClass.name().toString());
                this.processClass(deploymentUnit, annotation, declaringClass, eeModuleClassDescription2);
            }
            if (declaringClass == null || (componentDescription = eeModuleDescription.getComponentByClassName(declaringClass.name().toString())) == null) continue;
            this.registerInterceptorsForExtendedPersistenceContext(componentDescription, annotation);
        }
    }

    private void processField(DeploymentUnit deploymentUnit, AnnotationInstance annotation, FieldInfo fieldInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : declaredName;
        DotName declaredTypeDotName = fieldInfo.type().name();
        DotName injectionTypeDotName = declaredTypeDotName == null || declaredTypeDotName.toString().equals(Object.class.getName()) ? fieldInfo.type().name() : declaredTypeDotName;
        String injectionType = injectionTypeDotName.toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType);
        final BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
        eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
        FieldInjectionTarget injectionTarget = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, fieldInfo.type().name().toString());
        LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
        final ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
        eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getInjectionConfigurations().add(injectionConfiguration);
            }
        });
    }

    private void processMethod(DeploymentUnit deploymentUnit, AnnotationInstance annotation, MethodInfo methodInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        AnnotationValue declaredNameValue = annotation.value("name");
        String declaredName = declaredNameValue != null ? declaredNameValue.asString() : null;
        String localContextName = declaredName == null || declaredName.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : declaredName;
        String injectionType = methodInfo.args()[0].name().toString();
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, injectionType);
        final BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, bindingSource);
        eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
        MethodInjectionTarget injectionTarget = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodInfo.args()[0].name().toString());
        LookupInjectionSource injectionSource = new LookupInjectionSource(localContextName);
        final ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration((InjectionTarget)injectionTarget, (InjectionSource)injectionSource);
        eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getInjectionConfigurations().add(injectionConfiguration);
            }
        });
    }

    private void processClass(DeploymentUnit deploymentUnit, AnnotationInstance annotation, ClassInfo classInfo, EEModuleClassDescription eeModuleClassDescription) throws DeploymentUnitProcessingException {
        AnnotationValue nameValue = annotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw new IllegalArgumentException("Class level annotations must provide a name.");
        }
        String name = nameValue.asString();
        String type = this.getClassLevelInjectionType(annotation);
        InjectionSource bindingSource = this.getBindingSource(deploymentUnit, annotation, type);
        final BindingConfiguration bindingConfiguration = new BindingConfiguration(name, bindingSource);
        eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
    }

    private InjectionSource getBindingSource(DeploymentUnit deploymentUnit, AnnotationInstance annotation, String injectionTypeName) throws DeploymentUnitProcessingException {
        String scopedPuName = this.getScopedPuName(deploymentUnit, annotation);
        ServiceName puServiceName = this.getPuServiceName(scopedPuName);
        if (this.isPersistenceContext(annotation)) {
            HashMap<AnnotationValue, AnnotationValue> properties;
            AnnotationInstance[] props;
            AnnotationValue pcType = annotation.value("type");
            PersistenceContextType type = pcType == null || PersistenceContextType.TRANSACTION.name().equals(pcType.asString()) ? PersistenceContextType.TRANSACTION : PersistenceContextType.EXTENDED;
            AnnotationValue value = annotation.value("properties");
            AnnotationInstance[] annotationInstanceArray = props = value != null ? value.asNestedArray() : null;
            if (props != null) {
                properties = new HashMap<AnnotationValue, AnnotationValue>();
                for (int source = 0; source < props.length; ++source) {
                    properties.put(props[source].value("name"), props[source].value("value"));
                }
            } else {
                properties = null;
            }
            return new PersistenceContextInjectionSource(type, properties, puServiceName, deploymentUnit, scopedPuName, injectionTypeName);
        }
        return new PersistenceUnitInjectionSource(puServiceName, deploymentUnit, scopedPuName, injectionTypeName);
    }

    private boolean isExtendedPersistenceContext(AnnotationInstance annotation) {
        AnnotationValue value = annotation.value("type");
        return annotation.name().local().equals("PersistenceContext") && value != null && PersistenceContextType.EXTENDED.name().equals(value.asString());
    }

    private boolean isPersistenceContext(AnnotationInstance annotation) {
        return annotation.name().local().equals("PersistenceContext");
    }

    private String getClassLevelInjectionType(AnnotationInstance annotation) {
        boolean isPC = annotation.name().local().equals("PersistenceContext");
        return isPC ? ENTITY_MANAGER_CLASS : ENTITY_MANAGERFACTORY_CLASS;
    }

    private String getScopedPuName(DeploymentUnit deploymentUnit, AnnotationInstance annotation) throws DeploymentUnitProcessingException {
        String scopedPuName;
        AnnotationValue puName = annotation.value("unitName");
        String searchName = null;
        if (puName != null) {
            searchName = puName.asString();
        }
        if (null == (scopedPuName = PersistenceUnitSearch.resolvePersistenceUnitSupplier(deploymentUnit, searchName))) {
            throw new DeploymentUnitProcessingException("Can't find a deployment unit named " + puName.asString() + " at " + deploymentUnit);
        }
        return scopedPuName;
    }

    private ServiceName getPuServiceName(String scopedPuName) throws DeploymentUnitProcessingException {
        return PersistenceUnitService.getPUServiceName(scopedPuName);
    }

    private void registerInterceptorsForExtendedPersistenceContext(ComponentDescription componentDescription, AnnotationInstance annotation) {
        if (componentDescription instanceof StatefulComponentDescription && this.isExtendedPersistenceContext(annotation)) {
            componentDescription.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.getPostConstructInterceptors().addFirst(new SFSBCreateInterceptorFactory());
                    configuration.getPreDestroyInterceptors().addFirst(new SFSBDestroyInterceptorFactory());
                }
            });
            List views = componentDescription.getViews();
            for (ViewDescription view : views) {
                view.getConfigurators().addFirst(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        Method[] viewMethods;
                        for (Method viewMethod : viewMethods = configuration.getProxyFactory().getCachedMethods()) {
                            configuration.getViewInterceptorDeque(viewMethod).addFirst(new ImmediateInterceptorFactory((Interceptor)SFSBInvocationInterceptor.INSTANCE));
                        }
                    }
                });
            }
        }
        if (!this.isExtendedPersistenceContext(annotation) && (componentDescription instanceof StatefulComponentDescription || componentDescription instanceof StatelessComponentDescription)) {
            componentDescription.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    for (Method method : configuration.getDefinedComponentMethods()) {
                        configuration.getComponentInterceptorDeque(method).addFirst(new ImmediateInterceptorFactory((Interceptor)SBInvocationInterceptor.INSTANCE));
                    }
                }
            });
        }
    }
}

