/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.jboss.as.jpa.config.PersistenceUnitMetadata;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderAdapterRegistry;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PersistenceUnitService
implements Service<PersistenceUnitService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"persistenceunit"});
    private final InjectedValue<Map> properties = new InjectedValue();
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private EntityManagerFactory entityManagerFactory;
    private PersistenceUnitMetadata pu;

    public PersistenceUnitService(PersistenceUnitMetadata pu, ResourceRoot resourceRoot) {
        this.pu = pu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            PersistenceProvider provider = this.lookupProvider(this.pu.getPersistenceProviderClassName());
            this.pu.setJtaDataSource((DataSource)this.jtaDataSource.getOptionalValue());
            this.pu.setNonJtaDataSource((DataSource)this.nonJtaDataSource.getOptionalValue());
            this.entityManagerFactory = this.createContainerEntityManagerFactory(provider);
        }
        finally {
            this.pu.setTempClassloader(null);
        }
    }

    public void stop(StopContext context) {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
            this.entityManagerFactory = null;
        }
    }

    public PersistenceUnitService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public Injector<Map> getPropertiesInjector() {
        return this.properties;
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public static ServiceName getPUServiceName(PersistenceUnitMetadata pu) {
        return SERVICE_NAME.append(new String[]{pu.getScopedPersistenceUnitName()});
    }

    public static ServiceName getPUServiceName(String scopedPersistenceUnitName) {
        return SERVICE_NAME.append(new String[]{scopedPersistenceUnitName});
    }

    private PersistenceProvider lookupProvider(String providerName) {
        List providers = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.getClass().getName().equals(providerName)) continue;
            return provider;
        }
        StringBuilder sb = new StringBuilder();
        for (PersistenceProvider provider : providers) {
            sb.append(provider.getClass().getName()).append(", ");
        }
        throw new PersistenceException("PersistenceProvider '" + providerName + "' not found in {" + sb.toString() + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactory createContainerEntityManagerFactory(PersistenceProvider provider) {
        PersistenceProviderAdaptor adaptor = PersistenceProviderAdapterRegistry.getPersistenceProviderAdaptor(this.pu.getPersistenceProviderClassName());
        adaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        try {
            EntityManagerFactory entityManagerFactory = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.pu, (Map)this.properties.getValue());
            return entityManagerFactory;
        }
        finally {
            try {
                adaptor.afterCreateContainerEntityManagerFactory(this.pu);
            }
            finally {
                this.pu.setAnnotationIndex(null);
                this.pu.setTempClassloader(null);
            }
        }
    }
}

