/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Level;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public abstract class HandlerUpdateProperties
implements ModelUpdateOperationHandler {
    static final String OPERATION_NAME = "update-properties";

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set(OPERATION_NAME);
        compensatingOperation.get("address").set(opAddr);
        if (operation.hasDefined("level")) {
            this.apply(model, compensatingOperation, "level");
            this.apply(operation, model, "level");
        }
        if (operation.hasDefined("formatter")) {
            this.apply(model, compensatingOperation, "formatter");
            this.apply(operation, model, "formatter");
        }
        if (operation.hasDefined("encoding")) {
            this.apply(model, compensatingOperation, "encoding");
            this.apply(operation, model, "encoding");
        }
        this.updateModel(operation, compensatingOperation, model);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry();
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        Handler handler = (Handler)controller.getValue();
                        if (operation.hasDefined("level")) {
                            handler.setLevel(Level.parse((String)operation.get("level").asString()));
                        }
                        if (operation.hasDefined("formatter")) {
                            new PatternFormatterSpec(operation.get("formatter").asString()).apply(handler);
                        }
                        if (operation.hasDefined("encoding")) {
                            try {
                                handler.setEncoding(operation.get("encoding").asString());
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to set handler encoding."));
                            }
                        }
                        HandlerUpdateProperties.this.updateRuntime(operation, handler);
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    protected abstract void updateModel(ModelNode var1, ModelNode var2, ModelNode var3);

    protected abstract void updateRuntime(ModelNode var1, Handler var2);

    protected void apply(ModelNode from, ModelNode to, String ... attributePath) {
        if (from.get(attributePath).isDefined()) {
            to.get(attributePath).set(from.get(attributePath));
        }
    }
}

