/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.management.client.content;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.management.client.content.ManagedDMRContentResource;
import org.jboss.dmr.ModelNode;

public class ManagedDMRContentAddHandler
implements OperationStepHandler,
DescriptionProvider {
    private final AttributeDefinition contentAttribute;
    private final ResourceDescriptionResolver descriptionResolver;

    public ManagedDMRContentAddHandler(AttributeDefinition contentAttribute, ResourceDescriptionResolver descriptionResolver) {
        this.contentAttribute = contentAttribute;
        this.descriptionResolver = descriptionResolver;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathElement pe = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement();
        ModelNode model = new ModelNode();
        this.contentAttribute.validateAndSet(operation, model);
        ManagedDMRContentResource resource = new ManagedDMRContentResource(pe);
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        resource.writeModel(model);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        DefaultOperationDescriptionProvider delegate = new DefaultOperationDescriptionProvider("add", this.descriptionResolver, new AttributeDefinition[]{this.contentAttribute});
        return delegate.getModelDescription(locale);
    }
}

