/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.hornetq.api.core.management.HornetQComponentControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;

public abstract class AbstractHornetQComponentControlHandler<T extends HornetQComponentControl>
extends AbstractRuntimeOnlyHandler {
    private static final String STOP = "stop";
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.messaging");
    private ParametersValidator readAttributeValidator = new ParametersValidator();

    protected AbstractHornetQComponentControlHandler() {
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        Object control = null;
        boolean appliedToRuntime = false;
        Object handback = null;
        if ("read-attribute".equals(operationName)) {
            this.readAttributeValidator.validate(operation);
            String name = operation.require("name").asString();
            if ("started".equals(name)) {
                control = this.getHornetQComponentControl(context, operation, false);
                context.getResult().set(control.isStarted());
            } else {
                this.handleReadAttribute(name, context, operation);
            }
        } else if ("start".equals(operationName)) {
            control = this.getHornetQComponentControl(context, operation, true);
            try {
                control.start();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        } else if (STOP.equals(operationName)) {
            control = this.getHornetQComponentControl(context, operation, true);
            try {
                control.stop();
                appliedToRuntime = true;
                context.getResult();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        } else {
            handback = this.handleOperation(operationName, context, operation);
            boolean bl = appliedToRuntime = handback != null;
        }
        if (context.completeStep() != OperationContext.ResultAction.KEEP && appliedToRuntime) {
            try {
                if ("start".equals(operationName)) {
                    control.stop();
                } else if (STOP.equals(operationName)) {
                    control.start();
                } else {
                    this.handleRevertOperation(operationName, context, operation, handback);
                }
            }
            catch (Exception e) {
                log.errorf((Throwable)e, String.format("%s caught exception attempting to revert operation %s at address %s", ((Object)((Object)this)).getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address"))), new Object[0]);
            }
        }
    }

    public void register(ManagementResourceRegistration registry) {
        registry.registerReadOnlyAttribute("started", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        registry.registerOperationHandler("start", (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, "start", AbstractHornetQComponentControlHandler.this.getDescriptionPrefix());
            }
        });
        registry.registerOperationHandler(STOP, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, AbstractHornetQComponentControlHandler.STOP, AbstractHornetQComponentControlHandler.this.getDescriptionPrefix());
            }
        });
    }

    protected abstract T getHornetQComponentControl(HornetQServer var1, PathAddress var2);

    protected abstract String getDescriptionPrefix();

    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedAttribute(attributeName);
    }

    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        this.unsupportedOperation(operationName);
        throw new IllegalStateException("unreachable statement");
    }

    protected void handleRevertOperation(String operationName, OperationContext context, ModelNode operation, Object handback) {
    }

    protected final void unsupportedAttribute(String attributeName) {
        throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", attributeName));
    }

    protected final void unsupportedOperation(String operationName) {
        throw new IllegalStateException(String.format("Support for operation %s was not properly implemented", operationName));
    }

    protected final T getHornetQComponentControl(OperationContext context, ModelNode operation, boolean forWrite) {
        ServiceController hqService = context.getServiceRegistry(forWrite).getService(MessagingServices.JBOSS_MESSAGING);
        HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return this.getHornetQComponentControl(server, address);
    }
}

