/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CamelCaseUtil;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class AddressControlHandler
extends AbstractRuntimeOnlyHandler
implements DescriptionProvider {
    public static AddressControlHandler INSTANCE = new AddressControlHandler();
    public static final String[] ATTRIBUTES = new String[]{"roles", "queue-names", "number-of-bytes-per-page", "number-of-pages", "binding-names"};
    public static final String GET_ROLES_AS_JSON = "get-roles-as-json";

    private AddressControlHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttribute(context, operation);
        } else if (GET_ROLES_AS_JSON.equals(operationName)) {
            this.handleGetRolesAsJson(context, operation);
        }
    }

    public void register(ManagementResourceRegistration registry) {
        for (String attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        registry.registerOperationHandler(GET_ROLES_AS_JSON, (OperationStepHandler)this, (DescriptionProvider)this, EnumSet.of(OperationEntry.Flag.READ_ONLY));
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, GET_ROLES_AS_JSON, "core-address", ModelType.STRING, true);
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation) {
        block10: {
            AddressControl addressControl = this.getAddressControl(context, operation);
            String name = operation.require("name").asString();
            try {
                if ("roles".equals(name)) {
                    String json = addressControl.getRolesAsJSON();
                    ModelNode camelCase = ModelNode.fromJSONString((String)json);
                    ModelNode converted = CamelCaseUtil.convertSecurityRole(camelCase);
                    context.getResult().set(converted);
                    break block10;
                }
                if ("queue-names".equals(name)) {
                    String[] queues = addressControl.getQueueNames();
                    ModelNode result = context.getResult();
                    result.setEmptyList();
                    for (String queue : queues) {
                        result.add(queue);
                    }
                    break block10;
                }
                if ("number-of-bytes-per-page".equals(name)) {
                    long l = addressControl.getNumberOfBytesPerPage();
                    context.getResult().set(l);
                    break block10;
                }
                if ("number-of-pages".equals(name)) {
                    int i = addressControl.getNumberOfPages();
                    context.getResult().set(i);
                    break block10;
                }
                if ("binding-names".equals(name)) {
                    String[] bindings = addressControl.getBindingNames();
                    ModelNode result = context.getResult();
                    result.setEmptyList();
                    for (String binding : bindings) {
                        result.add(binding);
                    }
                    break block10;
                }
                throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        }
        context.completeStep();
    }

    private void handleGetRolesAsJson(OperationContext context, ModelNode operation) {
        AddressControl addressControl = this.getAddressControl(context, operation);
        try {
            String json = addressControl.getRolesAsJSON();
            ModelNode camelCase = ModelNode.fromJSONString((String)json);
            ModelNode converted = CamelCaseUtil.convertSecurityRole(camelCase);
            context.getResult().set(converted.toJSONString(true));
            context.completeStep();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.toString());
        }
    }

    private AddressControl getAddressControl(OperationContext context, ModelNode operation) {
        String addressName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceController hqService = context.getServiceRegistry(false).getService(MessagingServices.JBOSS_MESSAGING);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return (AddressControl)AddressControl.class.cast(hqServer.getManagementService().getResource("core.address." + addressName));
    }
}

