/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.dmr.ModelNode;

class AddressSettingsWriteHandler
implements OperationStepHandler {
    static final AddressSettingsWriteHandler INSTANCE = new AddressSettingsWriteHandler();

    AddressSettingsWriteHandler() {
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
        for (SimpleAttributeDefinition attr : AddressSettingAdd.ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        String attribute = operation.require("name").asString();
        AttributeDefinition def = AddressSettingsWriteHandler.getAttributeDefinition(attribute);
        if (def == null) {
            context.getFailureDescription().set(new ModelNode().set(String.format("no such attribute (%s) ", attribute)));
        }
        def.getValidator().validateParameter("value", operation);
        resource.getModel().get(attribute).set(operation.get("value"));
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HornetQServer server = AddressSettingAdd.getServer(context);
                    PathAddress address = null;
                    HierarchicalRepository repository = null;
                    AddressSettings existingSettings = null;
                    if (server != null) {
                        ModelNode model = resource.getModel();
                        address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                        AddressSettings settings = AddressSettingAdd.createSettings(model);
                        repository = server.getAddressSettingsRepository();
                        String match = address.getLastElement().getValue();
                        existingSettings = (AddressSettings)repository.getMatch(match);
                        repository.addMatch(match, (Object)settings);
                    }
                    if (context.completeStep() != OperationContext.ResultAction.KEEP && existingSettings != null) {
                        repository.addMatch(address.getLastElement().getValue(), existingSettings);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    static final AttributeDefinition getAttributeDefinition(String attributeName) {
        for (SimpleAttributeDefinition def : AddressSettingAdd.ATTRIBUTES) {
            if (!def.getName().equals(attributeName)) continue;
            return def;
        }
        return null;
    }
}

