/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.OperationValidator;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class BroadcastGroupAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static final OperationValidator VALIDATOR = new OperationValidator.AttributeDefinitionOperationValidator(CommonAttributes.BROADCAST_GROUP_ATTRIBUTES);
    public static final BroadcastGroupAdd INSTANCE = new BroadcastGroupAdd();

    public static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = Util.getOperation((String)"add", (ModelNode)address, (ModelNode)subModel);
        return operation;
    }

    private BroadcastGroupAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        VALIDATOR.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController hqService = registry.getService(MessagingServices.JBOSS_MESSAGING);
        if (hqService != null) {
            context.reloadRequired();
        } else {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ServiceTarget target = context.getServiceTarget();
            if (model.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
                GroupBindingService bindingService = new GroupBindingService();
                target.addService(GroupBindingService.BROADCAST.append(new String[]{name}), (Service)bindingService).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get("socket-binding").asString()}), SocketBinding.class, bindingService.getBindingRef()).install();
            } else {
                ModelNode localAddrNode = CommonAttributes.LOCAL_BIND_ADDRESS.validateResolvedOperation(model);
                String localAddress = localAddrNode.isDefined() ? localAddrNode.asString() : null;
                String groupAddress = CommonAttributes.GROUP_ADDRESS.validateResolvedOperation(model).asString();
                int groupPort = CommonAttributes.GROUP_PORT.validateResolvedOperation(model).asInt();
                try {
                    InetAddress inet = localAddress != null ? InetAddress.getByName(localAddress) : InetAddress.getLocalHost();
                    NetworkInterface intf = NetworkInterface.getByInetAddress(inet);
                    NetworkInterfaceBinding b = new NetworkInterfaceBinding(Collections.singleton(intf), inet);
                    InetAddress group = InetAddress.getByName(groupAddress);
                    SocketBinding socketBinding = new SocketBinding(name, -1, false, group, groupPort, b, null);
                    GroupBindingService bindingService = new GroupBindingService();
                    target.addService(GroupBindingService.BROADCAST.append(new String[]{name}), (Service)bindingService).addInjectionValue(bindingService.getBindingRef(), (Value)new ImmediateValue((Object)socketBinding)).install();
                }
                catch (Exception e) {
                    throw new OperationFailedException(new ModelNode().set(e.getMessage()));
                }
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getBroadcastGroupAdd(locale);
    }

    static void addBroadcastGroupConfigs(Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("broadcast-group")) {
            List configs = configuration.getBroadcastGroupConfigurations();
            for (Property prop : model.get("broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = CommonAttributes.BROADCAST_PERIOD.validateResolvedOperation(model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                connectorRefs.add(ref.asString());
            }
        }
        return new BroadcastGroupConfiguration(name, null, 0, null, 0, broadcastPeriod, connectorRefs);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, SocketBinding socketBinding) {
        String localAddress = socketBinding.getAddress().toString();
        String groupAddress = socketBinding.getMulticastAddress().toString();
        int localPort = socketBinding.getPort();
        int groupPort = socketBinding.getMulticastPort();
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        return new BroadcastGroupConfiguration(name, localAddress, localPort, groupAddress, groupPort, broadcastPeriod, connectorRefs);
    }
}

