/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;

public class BroadcastGroupWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    public static final BroadcastGroupWriteAttributeHandler INSTANCE = new BroadcastGroupWriteAttributeHandler();
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    private BroadcastGroupWriteAttributeHandler() {
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            this.attributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
        }
    }

    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        super.modelChanged(context, operation, attributeName, newValue, currentValue);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource;
                AttributeDefinition attr = (AttributeDefinition)BroadcastGroupWriteAttributeHandler.this.attributes.get(attributeName);
                if (attr.hasAlternative((resource = context.readResource(PathAddress.EMPTY_ADDRESS)).getModel())) {
                    context.setRollbackOnly();
                    throw new OperationFailedException(new ModelNode().set(String.format("Alternative attribute of (%s) is already defined.", new Object[0]), attributeName));
                }
            }
        }, OperationContext.Stage.VERIFY);
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        return true;
    }
}

