/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.Locale;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CamelCaseUtil;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class HornetQServerControlHandler
extends AbstractRuntimeOnlyHandler {
    public static HornetQServerControlHandler INSTANCE = new HornetQServerControlHandler();
    public static final String[] ATTRIBUTES = new String[]{"started", "version"};
    public static final String GET_CONNECTORS_AS_JSON = "get-connectors-as-json";
    public static final String RESET_ALL_MESSAGE_COUNTERS = "reset-all-message-counters";
    public static final String RESET_ALL_MESSAGE_COUNTER_HISTORIES = "reset-all-message-counter-histories";
    public static final String LIST_PREPARED_TRANSACTIONS = "list-prepared-transactions";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON = "list-prepared-transaction-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML = "list-prepared-transaction-details-as-html";
    public static final String LIST_HEURISTIC_COMMITTED_TRANSACTIONS = "list-heuristic-committed-transactions";
    public static final String LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS = "list-heuristic-rolled-back-transactions";
    public static final String COMMIT_PREPARED_TRANSACTION = "commit-prepared-transaction";
    public static final String ROLLBACK_PREPARED_TRANSACTION = "rollback-prepared-transaction";
    public static final String LIST_REMOTE_ADDRESSES = "list-remote-addresses";
    public static final String CLOSE_CONNECTIONS_FOR_ADDRESS = "close-connections-for-address";
    public static final String LIST_CONNECTION_IDS = "list-connection-ids";
    public static final String LIST_PRODUCERS_INFO_AS_JSON = "list-producers-info-as-json";
    public static final String LIST_SESSIONS = "list-sessions";
    public static final String GET_ROLES = "get-roles";
    public static final String GET_ROLES_AS_JSON = "get-roles-as-json";
    public static final String GET_ADDRESS_SETTINGS_AS_JSON = "get-address-settings-as-json";
    public static final String FORCE_FAILOVER = "force-failover";
    public static final String HQ_SERVER = "hq-server";
    public static final String TRANSACTION_AS_BASE_64 = "transaction-as-base-64";
    public static final String ADDRESS_MATCH = "address-match";
    public static final String CONNECTION_ID = "connection-id";
    public static final String IP_ADDRESS = "ip-address";
    private final ParametersValidator transactionValidator = new ParametersValidator();
    private final ParametersValidator addressValidator = new ParametersValidator();
    private final ParametersValidator ipAddressValidator = new ParametersValidator();
    private final ParametersValidator optionalIpAddressValidator = new ParametersValidator();
    private final ParametersValidator connectionIdValidator = new ParametersValidator();

    private HornetQServerControlHandler() {
        StringLengthValidator stringLengthValidator = new StringLengthValidator(1);
        this.transactionValidator.registerValidator(TRANSACTION_AS_BASE_64, (ParameterValidator)stringLengthValidator);
        this.addressValidator.registerValidator(ADDRESS_MATCH, (ParameterValidator)stringLengthValidator);
        this.ipAddressValidator.registerValidator(IP_ADDRESS, (ParameterValidator)stringLengthValidator);
        this.optionalIpAddressValidator.registerValidator(IP_ADDRESS, (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.connectionIdValidator.registerValidator(CONNECTION_ID, (ParameterValidator)stringLengthValidator);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block23: {
            String operationName = operation.require("operation").asString();
            HornetQServerControl serverControl = this.getServerControl(context, operation);
            try {
                if ("read-attribute".equals(operationName)) {
                    this.handleReadAttribute(context, operation, serverControl);
                    break block23;
                }
                if (GET_CONNECTORS_AS_JSON.equals(operationName)) {
                    String json = serverControl.getConnectorsAsJSON();
                    context.getResult().set(json);
                    break block23;
                }
                if (RESET_ALL_MESSAGE_COUNTERS.equals(operationName)) {
                    serverControl.resetAllMessageCounters();
                    context.getResult();
                    break block23;
                }
                if (RESET_ALL_MESSAGE_COUNTER_HISTORIES.equals(operationName)) {
                    serverControl.resetAllMessageCounterHistories();
                    context.getResult();
                    break block23;
                }
                if (LIST_PREPARED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listPreparedTransactions();
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block23;
                }
                if (LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block23;
                }
                if (LIST_HEURISTIC_COMMITTED_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicCommittedTransactions();
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS.equals(operationName)) {
                    String[] list = serverControl.listHeuristicRolledBackTransactions();
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (COMMIT_PREPARED_TRANSACTION.equals(operationName)) {
                    this.transactionValidator.validate(operation);
                    String txId = operation.require(TRANSACTION_AS_BASE_64).asString();
                    boolean committed = serverControl.commitPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block23;
                }
                if (ROLLBACK_PREPARED_TRANSACTION.equals(operationName)) {
                    this.transactionValidator.validate(operation);
                    String txId = operation.require(TRANSACTION_AS_BASE_64).asString();
                    boolean committed = serverControl.rollbackPreparedTransaction(txId);
                    context.getResult().set(committed);
                    break block23;
                }
                if (LIST_REMOTE_ADDRESSES.equals(operationName)) {
                    this.optionalIpAddressValidator.validate(operation);
                    ModelNode addr = operation.get(IP_ADDRESS);
                    String[] list = addr.isDefined() ? serverControl.listRemoteAddresses(addr.asString()) : serverControl.listRemoteAddresses();
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (CLOSE_CONNECTIONS_FOR_ADDRESS.equals(operationName)) {
                    this.ipAddressValidator.validate(operation);
                    boolean closed = serverControl.closeConnectionsForAddress(operation.require(IP_ADDRESS).asString());
                    context.getResult().set(closed);
                    break block23;
                }
                if (LIST_CONNECTION_IDS.equals(operationName)) {
                    String[] list = serverControl.listConnectionIDs();
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (LIST_PRODUCERS_INFO_AS_JSON.equals(operationName)) {
                    String json = serverControl.listProducersInfoAsJSON();
                    context.getResult().set(json);
                    break block23;
                }
                if (LIST_SESSIONS.equals(operationName)) {
                    this.connectionIdValidator.validate(operation);
                    String[] list = serverControl.listSessions(operation.require(CONNECTION_ID).asString());
                    this.reportListOfString(context, list);
                    break block23;
                }
                if (GET_ROLES.equals(operationName)) {
                    this.addressValidator.validate(operation);
                    String json = serverControl.getRolesAsJSON(operation.require(ADDRESS_MATCH).asString());
                    ModelNode camelCase = ModelNode.fromJSONString((String)json);
                    ModelNode converted = CamelCaseUtil.convertSecurityRole(camelCase);
                    context.getResult().set(converted);
                    break block23;
                }
                if (GET_ROLES_AS_JSON.equals(operationName)) {
                    this.addressValidator.validate(operation);
                    String json = serverControl.getRolesAsJSON(operation.require(ADDRESS_MATCH).asString());
                    ModelNode camelCase = ModelNode.fromJSONString((String)json);
                    ModelNode converted = CamelCaseUtil.convertSecurityRole(camelCase);
                    json = converted.toJSONString(true);
                    context.getResult().set(json);
                    break block23;
                }
                if (GET_ADDRESS_SETTINGS_AS_JSON.equals(operationName)) {
                    this.addressValidator.validate(operation);
                    String json = serverControl.getAddressSettingsAsJSON(operation.require(ADDRESS_MATCH).asString());
                    context.getResult().set(json);
                    break block23;
                }
                if (FORCE_FAILOVER.equals(operationName)) {
                    serverControl.forceFailover();
                    context.getResult();
                    break block23;
                }
                throw new IllegalStateException(String.format("Support for operation %s was not properly implemented", operationName));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.toString());
            }
        }
        context.completeStep();
    }

    public void register(ManagementResourceRegistration registry) {
        for (String attr : ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        registry.registerOperationHandler(GET_CONNECTORS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.GET_CONNECTORS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(RESET_ALL_MESSAGE_COUNTERS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.RESET_ALL_MESSAGE_COUNTERS, HornetQServerControlHandler.HQ_SERVER);
            }
        });
        registry.registerOperationHandler(RESET_ALL_MESSAGE_COUNTER_HISTORIES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.RESET_ALL_MESSAGE_COUNTER_HISTORIES, HornetQServerControlHandler.HQ_SERVER);
            }
        });
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTION_DETAILS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PREPARED_TRANSACTION_DETAILS_AS_HTML, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_HEURISTIC_COMMITTED_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_HEURISTIC_COMMITTED_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_HEURISTIC_ROLLED_BACK_TRANSACTIONS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(COMMIT_PREPARED_TRANSACTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.COMMIT_PREPARED_TRANSACTION, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.TRANSACTION_AS_BASE_64, ModelType.STRING, true, ModelType.BOOLEAN, true);
            }
        });
        registry.registerOperationHandler(ROLLBACK_PREPARED_TRANSACTION, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.ROLLBACK_PREPARED_TRANSACTION, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.TRANSACTION_AS_BASE_64, ModelType.STRING, true, ModelType.BOOLEAN, true);
            }
        });
        registry.registerOperationHandler(LIST_REMOTE_ADDRESSES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_REMOTE_ADDRESSES, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.IP_ADDRESS, ModelType.STRING, true, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(CLOSE_CONNECTIONS_FOR_ADDRESS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.CLOSE_CONNECTIONS_FOR_ADDRESS, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.IP_ADDRESS, ModelType.STRING, false, ModelType.BOOLEAN, true);
            }
        });
        registry.registerOperationHandler(LIST_CONNECTION_IDS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_CONNECTION_IDS, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_PRODUCERS_INFO_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, HornetQServerControlHandler.LIST_PRODUCERS_INFO_AS_JSON, HornetQServerControlHandler.HQ_SERVER, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(LIST_SESSIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleListReplyOperation(locale, HornetQServerControlHandler.LIST_SESSIONS, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.CONNECTION_ID, ModelType.STRING, true, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(GET_ROLES, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getGetRoles(locale);
            }
        }, readOnly);
        registry.registerOperationHandler(GET_ROLES_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.GET_ROLES_AS_JSON, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.ADDRESS_MATCH, ModelType.STRING, false, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(GET_ADDRESS_SETTINGS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, HornetQServerControlHandler.GET_ADDRESS_SETTINGS_AS_JSON, HornetQServerControlHandler.HQ_SERVER, HornetQServerControlHandler.ADDRESS_MATCH, ModelType.STRING, false, ModelType.STRING, true);
            }
        }, readOnly);
        registry.registerOperationHandler(FORCE_FAILOVER, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getDescriptionOnlyOperation(locale, HornetQServerControlHandler.FORCE_FAILOVER, HornetQServerControlHandler.HQ_SERVER);
            }
        });
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation, HornetQServerControl serverControl) {
        String name = operation.require("name").asString();
        if ("started".equals(name)) {
            boolean started = serverControl.isStarted();
            context.getResult().set(started);
        } else if ("started".equals(name)) {
            boolean started = serverControl.isStarted();
            context.getResult().set(started);
        } else if ("version".equals(name)) {
            String version = serverControl.getVersion();
            context.getResult().set(version);
        } else {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
        }
    }

    private HornetQServerControl getServerControl(OperationContext context, ModelNode operation) {
        ServiceController hqService = context.getServiceRegistry(false).getService(MessagingServices.JBOSS_MESSAGING);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return hqServer.getHornetQServerControl();
    }

    private void reportListOfString(OperationContext context, String[] list) {
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String tx : list) {
            result.add(tx);
        }
    }
}

