/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class HornetQServerControlWriteHandler
extends ServerWriteAttributeOperationHandler {
    public static final HornetQServerControlWriteHandler INSTANCE = new HornetQServerControlWriteHandler();
    private static final EnumSet<AttributeAccess.Flag> RESTART_NONE = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
    private static final EnumSet<AttributeAccess.Flag> RESTART_ALL = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
    private final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    private HornetQServerControlWriteHandler() {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            this.attributes.put(attr.getName(), attr);
        }
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_WRITE_ATTRIBUTES) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            String attrName = attr.getName();
            EnumSet<AttributeAccess.Flag> flags = this.runtimeAttributes.containsKey(attrName) ? RESTART_NONE : RESTART_ALL;
            registry.registerReadWriteAttribute(attrName, null, (OperationStepHandler)this, flags);
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateResolvedParameter(name, value);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(MessagingServices.JBOSS_MESSAGING);
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        this.applyOperationToHornetQService(operation, attributeName, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert) throws OperationFailedException {
        ServiceRegistry registry;
        ServiceController hqService;
        if (this.runtimeAttributes.containsKey(attributeName) && (hqService = (registry = context.getServiceRegistry(true)).getService(MessagingServices.JBOSS_MESSAGING)) != null && hqService.getState() == ServiceController.State.UP) {
            ModelNode revertOp = operation.clone();
            revertOp.get(attributeName).set(valueToRestore);
            this.applyOperationToHornetQService(revertOp, attributeName, hqService);
        }
    }

    private void applyOperationToHornetQService(ModelNode operation, String attributeName, ServiceController<?> hqService) {
        block9: {
            HornetQServerControlImpl serverControl = ((HornetQServer)HornetQServer.class.cast(hqService.getValue())).getHornetQServerControl();
            try {
                if (attributeName.equals(CommonAttributes.FAILOVER_ON_SHUTDOWN.getName())) {
                    serverControl.setFailoverOnServerShutdown(CommonAttributes.FAILOVER_ON_SHUTDOWN.validateResolvedOperation(operation).asBoolean());
                    break block9;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.getName())) {
                    serverControl.setMessageCounterSamplePeriod(CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.validateResolvedOperation(operation).asLong());
                    break block9;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.getName())) {
                    serverControl.setMessageCounterMaxDayCount(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.validateResolvedOperation(operation).asInt());
                    break block9;
                }
                if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName())) {
                    boolean enabled = CommonAttributes.MESSAGE_COUNTER_ENABLED.validateResolvedOperation(operation).asBoolean();
                    if (enabled) {
                        serverControl.enableMessageCounters();
                    } else {
                        serverControl.disableMessageCounters();
                    }
                    break block9;
                }
                throw new UnsupportedOperationException(String.format("Runtime handling for %s is not implemented", attributeName));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

