/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.SecurityActions;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class HornetQService
implements Service<HornetQServer> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.messaging");
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String LOGGING_FACTORY = "org.jboss.as.messaging.HornetQLoggerFactory";
    private static final String SOCKET_REF = CommonAttributes.SOCKET_BINDING.getName();
    private Configuration configuration;
    private HornetQServer server;
    private Map<String, String> paths = new HashMap<String, String>();
    private Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>();
    private Map<String, SocketBinding> groupBindings = new HashMap<String, SocketBinding>();
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();

    HornetQService() {
    }

    Injector<String> getPathInjector(String name) {
        return new MapInjector(this.paths, (Object)name);
    }

    Injector<SocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    Injector<SocketBinding> getGroupBindingInjector(String name) {
        return new MapInjector(this.groupBindings, (Object)name);
    }

    InjectedValue<MBeanServer> getMBeanServer() {
        return this.mbeanServer;
    }

    public synchronized void start(StartContext context) throws StartException {
        boolean supportsAIO;
        ClassLoader origTCCL = SecurityActions.getContextClassLoader();
        JournalType jtype = this.configuration.getJournalType();
        if (jtype == JournalType.ASYNCIO && !(supportsAIO = AIOSequentialFileFactory.isSupported())) {
            log.warn((Object)"AIO wasn't located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal");
            this.configuration.setJournalType(JournalType.NIO);
        }
        this.configuration.setFileDeploymentEnabled(false);
        this.configuration.setLogDelegateFactoryClassName(LOGGING_FACTORY);
        this.configuration.setBindingsDirectory(this.paths.get("bindings"));
        this.configuration.setLargeMessagesDirectory(this.paths.get("largemessages"));
        this.configuration.setJournalDirectory(this.paths.get("journal"));
        this.configuration.setPagingDirectory(this.paths.get("paging"));
        this.configuration.setSecurityEnabled(false);
        try {
            SocketBinding binding;
            String name;
            Object socketRef;
            Set acceptors = this.configuration.getAcceptorConfigurations();
            Collection connectors = this.configuration.getConnectorConfigurations().values();
            List broadcastGroups = this.configuration.getBroadcastGroupConfigurations();
            Map discoveryGroups = this.configuration.getDiscoveryGroupConfigurations();
            if (connectors != null) {
                for (TransportConfiguration transportConfiguration : connectors) {
                    socketRef = transportConfiguration.getParams().remove(SOCKET_REF);
                    if (socketRef == null) continue;
                    name = socketRef.toString();
                    binding = this.socketBindings.get(name);
                    if (binding == null) {
                        throw new StartException("Failed to find SocketBinding for connector: " + transportConfiguration.getName());
                    }
                    transportConfiguration.getParams().put(HOST, binding.getSocketAddress().getHostName());
                    transportConfiguration.getParams().put(PORT, "" + binding.getSocketAddress().getPort());
                }
            }
            if (acceptors != null) {
                for (TransportConfiguration transportConfiguration : acceptors) {
                    socketRef = transportConfiguration.getParams().remove(SOCKET_REF);
                    if (socketRef == null) continue;
                    name = socketRef.toString();
                    binding = this.socketBindings.get(name);
                    if (binding == null) {
                        throw new StartException("Failed to find SocketBinding for connector: " + transportConfiguration.getName());
                    }
                    transportConfiguration.getParams().put(HOST, binding.getSocketAddress().getHostName());
                    transportConfiguration.getParams().put(PORT, "" + binding.getSocketAddress().getPort());
                }
            }
            if (broadcastGroups != null) {
                ArrayList<BroadcastGroupConfiguration> newConfigs = new ArrayList<BroadcastGroupConfiguration>();
                for (BroadcastGroupConfiguration config : broadcastGroups) {
                    name = config.getName();
                    binding = this.groupBindings.get("broadcast" + name);
                    if (binding == null) {
                        throw new StartException("Failed to find SocketBinding for broadcast binding: " + name);
                    }
                    newConfigs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(name, config, binding));
                }
            }
            if (discoveryGroups != null) {
                this.configuration.setDiscoveryGroupConfigurations(new HashMap());
                for (Map.Entry entry : discoveryGroups.entrySet()) {
                    String name2 = (String)entry.getKey();
                    SocketBinding binding2 = this.groupBindings.get("discovery" + name2);
                    if (binding2 == null) {
                        throw new StartException("Failed to find SocketBinding for discovery binding: " + (String)entry.getKey());
                    }
                    DiscoveryGroupConfiguration config = DiscoveryGroupAdd.createDiscoveryGroupConfiguration(name2, (DiscoveryGroupConfiguration)entry.getValue(), binding2);
                    this.configuration.getDiscoveryGroupConfigurations().put(name2, config);
                }
            }
            this.server = new HornetQServerImpl(this.configuration, (MBeanServer)this.mbeanServer.getOptionalValue(), null);
        }
        catch (Exception e) {
            throw new StartException("Failed to start service", (Throwable)e);
        }
        finally {
            SecurityActions.setContextClassLoader(origTCCL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stop(StopContext context) {
        try {
            if (this.server == null) return;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to shutdown HornetQ server", e);
        }
    }

    public synchronized HornetQServer getValue() throws IllegalStateException {
        HornetQServer server = this.server;
        if (server == null) {
            throw new IllegalStateException();
        }
        return server;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration hqConfig) {
        this.configuration = hqConfig;
    }
}

