/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.BroadcastGroupConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.HornetQServerResource;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.JMSService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class MessagingSubsystemAdd
implements OperationStepHandler,
DescriptionProvider {
    private static final String DEFAULT_PATH = "messaging";
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    static final ServiceName PATH_BASE = MessagingServices.JBOSS_MESSAGING.append(new String[]{"paths"});
    static final String DEFAULT_BINDINGS_DIR = "bindings";
    static final String DEFAULT_JOURNAL_DIR = "journal";
    static final String DEFAULT_LARGE_MESSSAGE_DIR = "largemessages";
    static final String DEFAULT_PAGING_DIR = "paging";
    public static final MessagingSubsystemAdd INSTANCE = new MessagingSubsystemAdd();

    private MessagingSubsystemAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final HornetQServerResource resource = new HornetQServerResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        model.get("queue").setEmptyObject();
        model.get("connection-factory").setEmptyObject();
        model.get("jms-queue").setEmptyObject();
        model.get("jms-topic").setEmptyObject();
        model.get("pooled-connection-factory").setEmptyObject();
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    MessagingSubsystemAdd.this.performRuntime(context, resource, verificationHandler, controllers);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        for (ServiceController controller : controllers) {
                            context.removeService(controller.getName());
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    private void performRuntime(OperationContext context, final HornetQServerResource resource, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName groupBinding;
                String name;
                ServiceTarget serviceTarget = context.getServiceTarget();
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                Configuration configuration = MessagingSubsystemAdd.this.transformConfig(model);
                ServiceName bindingsPath = MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_BINDINGS_DIR, model.get(new String[]{"path", "bindings-directory"}), serviceTarget);
                ServiceName journalPath = MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_JOURNAL_DIR, model.get(new String[]{"path", "journal-directory"}), serviceTarget);
                ServiceName largeMessagePath = MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_LARGE_MESSSAGE_DIR, model.get(new String[]{"path", "large-messages-directory"}), serviceTarget);
                ServiceName pagingPath = MessagingSubsystemAdd.createDirectoryService(MessagingSubsystemAdd.DEFAULT_PAGING_DIR, model.get(new String[]{"path", "paging-directory"}), serviceTarget);
                HornetQService hqService = new HornetQService();
                hqService.setConfiguration(configuration);
                ServiceBuilder serviceBuilder = serviceTarget.addService(MessagingServices.JBOSS_MESSAGING, (Service)hqService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, hqService.getMBeanServer());
                serviceBuilder.addDependency(bindingsPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_BINDINGS_DIR));
                serviceBuilder.addDependency(journalPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_JOURNAL_DIR));
                serviceBuilder.addDependency(largeMessagePath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_LARGE_MESSSAGE_DIR));
                serviceBuilder.addDependency(pagingPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_PAGING_DIR));
                HashSet<String> socketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processAcceptors(configuration, model, socketBindings);
                TransportConfigOperationHandlers.processConnectors(configuration, model, socketBindings);
                for (String socketBinding : socketBindings) {
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, hqService.getSocketBindingInjector(socketBinding));
                }
                List broadcastGroupConfigurations = configuration.getBroadcastGroupConfigurations();
                Map discoveryGroupConfigurations = configuration.getDiscoveryGroupConfigurations();
                if (broadcastGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : broadcastGroupConfigurations) {
                        name = config.getName();
                        groupBinding = GroupBindingService.BROADCAST.append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, hqService.getGroupBindingInjector("broadcast" + name));
                    }
                }
                if (discoveryGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : discoveryGroupConfigurations.values()) {
                        name = config.getName();
                        groupBinding = GroupBindingService.DISCOVERY.append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, hqService.getGroupBindingInjector("discovery" + name));
                    }
                }
                serviceBuilder.addListener((ServiceListener)verificationHandler);
                ServiceController hqServerServiceController = serviceBuilder.install();
                resource.setHornetQServerServiceController((ServiceController<HornetQServer>)hqServerServiceController);
                newControllers.add(hqServerServiceController);
                newControllers.add(JMSService.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    Configuration transformConfig(ModelNode model) throws OperationFailedException {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setAllowAutoFailBack(CommonAttributes.ALLOW_FAILBACK.validateResolvedOperation(model).asBoolean());
        configuration.setEnabledAsyncConnectionExecution(CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setBackup(CommonAttributes.BACKUP.validateResolvedOperation(model).asBoolean());
        if (model.hasDefined(CommonAttributes.LIVE_CONNECTOR_REF.getName())) {
            configuration.setLiveConnectorName(CommonAttributes.LIVE_CONNECTOR_REF.validateResolvedOperation(model).asString());
        }
        configuration.setClustered(CommonAttributes.CLUSTERED.validateResolvedOperation(model).asBoolean());
        configuration.setClusterPassword(CommonAttributes.CLUSTER_PASSWORD.validateResolvedOperation(model).asString());
        configuration.setClusterUser(CommonAttributes.CLUSTER_USER.validateResolvedOperation(model).asString());
        configuration.setConnectionTTLOverride((long)CommonAttributes.CONNECTION_TTL_OVERRIDE.validateResolvedOperation(model).asInt());
        configuration.setCreateBindingsDir(CommonAttributes.CREATE_BINDINGS_DIR.validateResolvedOperation(model).asBoolean());
        configuration.setCreateJournalDir(CommonAttributes.CREATE_JOURNAL_DIR.validateResolvedOperation(model).asBoolean());
        configuration.setFailbackDelay(CommonAttributes.FAILBACK_DELAY.validateResolvedOperation(model).asLong());
        configuration.setFailoverOnServerShutdown(CommonAttributes.FAILOVER_ON_SHUTDOWN.validateResolvedOperation(model).asBoolean());
        configuration.setIDCacheSize(CommonAttributes.ID_CACHE_SIZE.validateResolvedOperation(model).asInt());
        configuration.setJMXDomain(CommonAttributes.JMX_DOMAIN.validateResolvedOperation(model).asString());
        configuration.setJMXManagementEnabled(CommonAttributes.JMX_MANAGEMENT_ENABLED.validateResolvedOperation(model).asBoolean());
        JournalType journalType = JournalType.valueOf((String)CommonAttributes.JOURNAL_TYPE.validateResolvedOperation(model).asString());
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(CommonAttributes.JOURNAL_BUFFER_SIZE.validateResolvedOperation(model).asInt(501760));
        configuration.setJournalBufferTimeout_AIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.validateResolvedOperation(model).asInt(500000));
        configuration.setJournalMaxIO_AIO(CommonAttributes.JOURNAL_MAX_IO.validateResolvedOperation(model).asInt(500));
        configuration.setJournalBufferSize_NIO(CommonAttributes.JOURNAL_BUFFER_SIZE.validateResolvedOperation(model).asInt(501760));
        configuration.setJournalBufferTimeout_NIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.validateResolvedOperation(model).asInt(3333333));
        configuration.setJournalMaxIO_NIO(CommonAttributes.JOURNAL_MAX_IO.validateResolvedOperation(model).asInt(1));
        configuration.setJournalCompactMinFiles(CommonAttributes.JOURNAL_COMPACT_MIN_FILES.validateResolvedOperation(model).asInt());
        configuration.setJournalCompactPercentage(CommonAttributes.JOURNAL_COMPACT_PERCENTAGE.validateResolvedOperation(model).asInt());
        configuration.setJournalFileSize(CommonAttributes.JOURNAL_FILE_SIZE.validateResolvedOperation(model).asInt());
        configuration.setJournalMinFiles(CommonAttributes.JOURNAL_MIN_FILES.validateResolvedOperation(model).asInt());
        configuration.setJournalSyncNonTransactional(CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL.validateResolvedOperation(model).asBoolean());
        configuration.setJournalSyncTransactional(CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL.validateResolvedOperation(model).asBoolean());
        configuration.setLogJournalWriteRate(CommonAttributes.LOG_JOURNAL_WRITE_RATE.validateResolvedOperation(model).asBoolean());
        configuration.setManagementAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_ADDRESS.validateResolvedOperation(model).asString()));
        configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS.validateResolvedOperation(model).asString()));
        configuration.setMemoryMeasureInterval(CommonAttributes.MEMORY_MEASURE_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setMemoryWarningThreshold(CommonAttributes.MEMORY_WARNING_THRESHOLD.validateResolvedOperation(model).asInt());
        configuration.setMessageCounterEnabled(CommonAttributes.MESSAGE_COUNTER_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setMessageCounterSamplePeriod((long)CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.validateResolvedOperation(model).asInt());
        configuration.setMessageCounterMaxDayHistory(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.validateResolvedOperation(model).asInt());
        configuration.setMessageExpiryScanPeriod(CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD.validateResolvedOperation(model).asLong());
        configuration.setMessageExpiryThreadPriority(CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY.validateResolvedOperation(model).asInt());
        if (model.hasDefined(CommonAttributes.NAME_OPTIONAL.getName())) {
            configuration.setName(CommonAttributes.NAME_OPTIONAL.validateResolvedOperation(model).asString());
        }
        configuration.setJournalPerfBlastPages(CommonAttributes.PERF_BLAST_PAGES.validateResolvedOperation(model).asInt());
        configuration.setPersistDeliveryCountBeforeDelivery(CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.validateResolvedOperation(model).asBoolean());
        configuration.setPersistenceEnabled(CommonAttributes.PERSISTENCE_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setPersistIDCache(CommonAttributes.PERSIST_ID_CACHE.validateResolvedOperation(model).asBoolean());
        configuration.setRunSyncSpeedTest(CommonAttributes.RUN_SYNC_SPEED_TEST.validateResolvedOperation(model).asBoolean());
        configuration.setScheduledThreadPoolMaxSize(CommonAttributes.SCHEDULED_THREAD_POOL_MAX_SIZE.validateResolvedOperation(model).asInt());
        configuration.setSecurityEnabled(CommonAttributes.SECURITY_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setSecurityInvalidationInterval(CommonAttributes.SECURITY_INVALIDATION_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setServerDumpInterval(CommonAttributes.SERVER_DUMP_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setSharedStore(CommonAttributes.SHARED_STORE.validateResolvedOperation(model).asBoolean());
        configuration.setThreadPoolMaxSize(CommonAttributes.THREAD_POOL_MAX_SIZE.validateResolvedOperation(model).asInt());
        configuration.setTransactionTimeout(CommonAttributes.TRANSACTION_TIMEOUT.validateResolvedOperation(model).asLong());
        configuration.setTransactionTimeoutScanPeriod(CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD.validateResolvedOperation(model).asLong());
        configuration.setWildcardRoutingEnabled(CommonAttributes.WILD_CARD_ROUTING_ENABLED.validateResolvedOperation(model).asBoolean());
        MessagingSubsystemAdd.processAddressSettings((Configuration)configuration, model);
        MessagingSubsystemAdd.processSecuritySettings((Configuration)configuration, model);
        GroupingHandlerAdd.addGroupingHandlerConfig((Configuration)configuration, model);
        BroadcastGroupAdd.addBroadcastGroupConfigs((Configuration)configuration, model);
        DiscoveryGroupAdd.addDiscoveryGroupConfigs((Configuration)configuration, model);
        DivertAdd.addDivertConfigs((Configuration)configuration, model);
        QueueAdd.addQueueConfigs((Configuration)configuration, model);
        BridgeAdd.addBridgeConfigs((Configuration)configuration, model);
        ClusterConnectionAdd.addClusterConnectionConfigs((Configuration)configuration, model);
        ConnectorServiceAdd.addConnectorServiceConfigs((Configuration)configuration, model);
        return configuration;
    }

    static void processAddressSettings(Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.hasDefined("address-setting")) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = AddressSettingAdd.createSettings(config);
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    static void processSecuritySettings(Configuration configuration, ModelNode params) {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (!config.hasDefined("role")) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.get("role").asPropertyList()) {
                    roles.add(SecurityRoleAdd.transform(role.getName(), role.getValue()));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSubsystemAdd(locale);
    }

    static ServiceName createDirectoryService(String name, ModelNode path, ServiceTarget serviceTarget) {
        ServiceName serviceName = PATH_BASE.append(new String[]{name});
        String relativeTo = path.hasDefined("relative-to") ? path.get("relative-to").asString() : DEFAULT_RELATIVE_TO;
        String pathName = path.hasDefined("path") ? path.get("path").asString() : DEFAULT_PATH + name;
        RelativePathService.addService((ServiceName)serviceName, (String)pathName, (String)relativeTo, (ServiceTarget)serviceTarget);
        return serviceName;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }
}

