/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class QueueService
implements Service<Void> {
    private final InjectedValue<HornetQServer> hornetQService = new InjectedValue();
    private final CoreQueueConfiguration queueConfiguration;
    private final boolean temporary;

    public QueueService(CoreQueueConfiguration queueConfiguration, boolean temporary) {
        if (queueConfiguration == null) {
            throw new IllegalArgumentException("null queue configuration");
        }
        this.queueConfiguration = queueConfiguration;
        this.temporary = temporary;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            HornetQServer hornetQService = (HornetQServer)this.hornetQService.getValue();
            hornetQService.deployQueue(new SimpleString(this.queueConfiguration.getAddress()), new SimpleString(this.queueConfiguration.getName()), SimpleString.toSimpleString((String)this.queueConfiguration.getFilterString()), this.queueConfiguration.isDurable(), this.temporary);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            HornetQServer hornetQService = (HornetQServer)this.hornetQService.getValue();
            hornetQService.destroyQueue(new SimpleString(this.queueConfiguration.getName()), null);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy queue (%s)", (Object)this.queueConfiguration.getName());
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<HornetQServer> getHornetQService() {
        return this.hornetQService;
    }
}

