/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

class SecurityRoleAdd
implements OperationStepHandler,
DescriptionProvider {
    static final SecurityRoleAdd INSTANCE = new SecurityRoleAdd();
    static final AttributeDefinition SEND = new RoleAttributeDefinition("send");
    static final AttributeDefinition CONSUME = new RoleAttributeDefinition("consume");
    static final AttributeDefinition CREATE_DURABLE_QUEUE = new RoleAttributeDefinition("create-durable-queue", "createDurableQueue");
    static final AttributeDefinition DELETE_DURABLE_QUEUE = new RoleAttributeDefinition("delete-durable-queue", "deleteDurableQueue");
    static final AttributeDefinition CREATE_NON_DURABLE_QUEUE = new RoleAttributeDefinition("create-non-durable-queue", "createTempQueue");
    static final AttributeDefinition DELETE_NON_DURABLE_QUEUE = new RoleAttributeDefinition("delete-non-durable-queue", "deleteTempQueue");
    static final AttributeDefinition MANAGE = new RoleAttributeDefinition("manage");
    static final AttributeDefinition[] ROLE_ATTRIBUTES = new AttributeDefinition[]{SEND, CONSUME, CREATE_DURABLE_QUEUE, DELETE_DURABLE_QUEUE, CREATE_NON_DURABLE_QUEUE, DELETE_NON_DURABLE_QUEUE, MANAGE};

    SecurityRoleAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        final ModelNode subModel = resource.getModel();
        for (AttributeDefinition attribute : ROLE_ATTRIBUTES) {
            attribute.validateAndSet(operation, subModel);
        }
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    HornetQServer server = SecurityRoleAdd.getServer(context);
                    if (server != null) {
                        String match = address.getElement(address.size() - 2).getValue();
                        String role = address.getLastElement().getValue();
                        Set roles = (Set)server.getSecurityRepository().getMatch(match);
                        roles.add(SecurityRoleAdd.transform(role, subModel));
                        server.getSecurityRepository().addMatch(match, (Object)roles);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSecurityRoleAdd(locale);
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (AttributeDefinition def : ROLE_ATTRIBUTES) {
            if (!subModel.hasDefined(def.getName())) continue;
            operation.get(def.getName()).set(subModel.get(def.getName()));
        }
        return operation;
    }

    static Role transform(String name, ModelNode node) {
        boolean send = node.get(SEND.getName()).asBoolean();
        boolean consume = node.get(CONSUME.getName()).asBoolean();
        boolean createDurableQueue = node.get(CREATE_DURABLE_QUEUE.getName()).asBoolean();
        boolean deleteDurableQueue = node.get(DELETE_DURABLE_QUEUE.getName()).asBoolean();
        boolean createNonDurableQueue = node.get(CREATE_NON_DURABLE_QUEUE.getName()).asBoolean();
        boolean deleteNonDurableQueue = node.get(DELETE_NON_DURABLE_QUEUE.getName()).asBoolean();
        boolean manage = node.get(MANAGE.getName()).asBoolean();
        return new Role(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage);
    }

    static HornetQServer getServer(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(MessagingServices.JBOSS_MESSAGING);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    static final class RoleAttributeDefinition
    extends SimpleAttributeDefinition {
        RoleAttributeDefinition(String name) {
            this(name, name);
        }

        RoleAttributeDefinition(String name, String xmlName) {
            super(name, xmlName, new ModelNode().set(false), ModelType.BOOLEAN, false, false, MeasurementUnit.NONE);
        }
    }
}

