/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class SecurityRoleAttributeHandler
extends ServerWriteAttributeOperationHandler {
    static final SecurityRoleAttributeHandler INSTANCE = new SecurityRoleAttributeHandler();

    SecurityRoleAttributeHandler() {
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
        for (AttributeDefinition attr : SecurityRoleAdd.ROLE_ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition def = SecurityRoleAttributeHandler.getAttributeDefinition(name);
        def.getValidator().validateParameter(name, value);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                HornetQServer server = SecurityRoleAttributeHandler.getServer(context);
                if (server != null) {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String match = address.getElement(address.size() - 2).getValue();
                    String roleName = address.getLastElement().getValue();
                    HashSet<Role> newRoles = new HashSet<Role>();
                    Set roles = (Set)server.getSecurityRepository().getMatch(match);
                    for (Role role : roles) {
                        if (roleName.equals(role.getName())) continue;
                        newRoles.add(role);
                    }
                    Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                    ModelNode subModel = resource.getModel();
                    Role updatedRole = SecurityRoleAdd.transform(roleName, subModel);
                    newRoles.add(updatedRole);
                    server.getSecurityRepository().addMatch(match, newRoles);
                }
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
        return false;
    }

    static HornetQServer getServer(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(MessagingServices.JBOSS_MESSAGING);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    static final AttributeDefinition getAttributeDefinition(String attributeName) {
        for (AttributeDefinition def : SecurityRoleAdd.ROLE_ATTRIBUTES) {
            if (!def.getName().equals(attributeName)) continue;
            return def;
        }
        return null;
    }
}

