/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class SecuritySettingAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final SecuritySettingAdd INSTANCE = new SecuritySettingAdd();

    SecuritySettingAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HornetQServer server = SecuritySettingAdd.getServer(context);
        if (server != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String match = address.getLastElement().getValue();
            server.getSecurityRepository().addMatch(match, new HashSet());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSecuritySettingAdd(locale);
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        return operation;
    }

    static HornetQServer getServer(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(MessagingServices.JBOSS_MESSAGING);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }
}

