/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class ConnectionFactoryWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    public static final ConnectionFactoryWriteAttributeHandler INSTANCE = new ConnectionFactoryWriteAttributeHandler();
    private static final EnumSet<AttributeAccess.Flag> RESTART_NONE = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
    private static final EnumSet<AttributeAccess.Flag> RESTART_ALL = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
    private final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    private ConnectionFactoryWriteAttributeHandler() {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            this.attributes.put(attr.getName(), attr);
        }
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_WRITE_ATTRS) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attr.getName();
            EnumSet<AttributeAccess.Flag> flags = this.runtimeAttributes.containsKey(attrName) ? RESTART_NONE : RESTART_ALL;
            registry.registerReadWriteAttribute(attrName, null, (OperationStepHandler)this, flags);
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateResolvedParameter(name, value);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(MessagingServices.JBOSS_MESSAGING);
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        this.applyOperationToHornetQService(operation, attributeName, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert) throws OperationFailedException {
        ServiceRegistry registry;
        ServiceController hqService;
        if (this.runtimeAttributes.containsKey(attributeName) && (hqService = (registry = context.getServiceRegistry(true)).getService(MessagingServices.JBOSS_MESSAGING)) != null && hqService.getState() == ServiceController.State.UP) {
            ModelNode revertOp = operation.clone();
            revertOp.get(attributeName).set(valueToRestore);
            this.applyOperationToHornetQService(revertOp, attributeName, hqService);
        }
    }

    private void applyOperationToHornetQService(ModelNode operation, String attributeName, ServiceController<?> hqService) {
        block32: {
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(server.getManagementService().getResource("jms.connectionfactory." + name));
            try {
                if (attributeName.equals(CommonAttributes.CLIENT_ID.getName())) {
                    ModelNode node = CommonAttributes.CLIENT_ID.validateResolvedOperation(operation);
                    control.setClientID(node.isDefined() ? node.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.COMPRESS_LARGE_MESSAGES.getName())) {
                    control.setCompressLargeMessages(CommonAttributes.COMPRESS_LARGE_MESSAGES.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.getName())) {
                    control.setClientFailureCheckPeriod(CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.validateResolvedOperation(operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CALL_TIMEOUT.getName())) {
                    control.setCallTimeout(CommonAttributes.CALL_TIMEOUT.validateResolvedOperation(operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.DUPS_OK_BATCH_SIZE.getName())) {
                    control.setDupsOKBatchSize(CommonAttributes.DUPS_OK_BATCH_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_MAX_RATE.getName())) {
                    control.setConsumerMaxRate(CommonAttributes.CONSUMER_MAX_RATE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_WINDOW_SIZE.getName())) {
                    control.setConsumerWindowSize(CommonAttributes.CONSUMER_WINDOW_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_MAX_RATE.getName())) {
                    control.setProducerMaxRate(CommonAttributes.PRODUCER_MAX_RATE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONFIRMATION_WINDOW_SIZE.getName())) {
                    control.setConfirmationWindowSize(CommonAttributes.CONFIRMATION_WINDOW_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_ACK.getName())) {
                    control.setBlockOnAcknowledge(CommonAttributes.BLOCK_ON_ACK.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_DURABLE_SEND.getName())) {
                    control.setBlockOnDurableSend(CommonAttributes.BLOCK_ON_DURABLE_SEND.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.getName())) {
                    control.setBlockOnNonDurableSend(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRE_ACK.getName())) {
                    control.setPreAcknowledge(CommonAttributes.PRE_ACK.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_TTL.getName())) {
                    control.setConnectionTTL(CommonAttributes.CONNECTION_TTL.validateResolvedOperation(operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.TRANSACTION_BATCH_SIZE.getName())) {
                    control.setTransactionBatchSize(CommonAttributes.TRANSACTION_BATCH_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.getName())) {
                    control.setMinLargeMessageSize(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.AUTO_GROUP.getName())) {
                    control.setAutoGroup(CommonAttributes.AUTO_GROUP.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL.getName())) {
                    control.setRetryInterval(CommonAttributes.RETRY_INTERVAL.validateResolvedOperation(operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.getName())) {
                    control.setRetryIntervalMultiplier(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.validateResolvedOperation(operation).asDouble());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.getName())) {
                    control.setReconnectAttempts(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.getName())) {
                    control.setFailoverOnInitialConnection(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_WINDOW_SIZE.getName())) {
                    control.setProducerWindowSize(CommonAttributes.PRODUCER_WINDOW_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.getName())) {
                    control.setCacheLargeMessagesClient(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MAX_RETRY_INTERVAL.getName())) {
                    control.setMaxRetryInterval(CommonAttributes.MAX_RETRY_INTERVAL.validateResolvedOperation(operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setScheduledThreadPoolMaxSize(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setThreadPoolMaxSize(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.validateResolvedOperation(operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.GROUP_ID.getName())) {
                    ModelNode node = CommonAttributes.GROUP_ID.validateResolvedOperation(operation);
                    control.setGroupID(node.isDefined() ? node.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.USE_GLOBAL_POOLS.getName())) {
                    control.setUseGlobalPools(CommonAttributes.USE_GLOBAL_POOLS.validateResolvedOperation(operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.LOAD_BALANCING_CLASS_NAME.getName())) {
                    control.setConnectionLoadBalancingPolicyClassName(CommonAttributes.LOAD_BALANCING_CLASS_NAME.validateResolvedOperation(operation).asString());
                    break block32;
                }
                throw new UnsupportedOperationException(String.format("Runtime handling for %s is not implemented", attributeName));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

