/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Locale;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.jms.AbstractAddJndiHandler;
import org.jboss.dmr.ModelNode;

public class JMSTopicAddJndiHandler
extends AbstractAddJndiHandler {
    public static final JMSTopicAddJndiHandler INSTANCE = new JMSTopicAddJndiHandler();

    private JMSTopicAddJndiHandler() {
    }

    @Override
    protected void addJndiNameToControl(String toAdd, String resourceName, HornetQServer server, OperationContext context) {
        ManagementService mgmt = server.getManagementService();
        TopicControl control = (TopicControl)TopicControl.class.cast(mgmt.getResource("jms.topic." + resourceName));
        try {
            control.addJNDI(toAdd);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.toString());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getAddJndiOperation(locale, "topic");
    }
}

