/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;

public class PooledConnectionFactoryWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    public static final PooledConnectionFactoryWriteAttributeHandler INSTANCE = new PooledConnectionFactoryWriteAttributeHandler();
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();

    private PooledConnectionFactoryWriteAttributeHandler() {
        for (AttributeDefinition attr : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            this.attributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)this, flags);
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        return true;
    }
}

