/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.NamespaceObjectFactory;
import org.jboss.as.naming.util.NameParser;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EEContextService
implements Service<Void> {
    private final InjectedValue<NamingStore> javaContext = new InjectedValue();
    private final String name;

    public EEContextService(String name) {
        this.name = name;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        Reference appReference = NamespaceObjectFactory.createReference(this.name);
        NamingStore javaContext = (NamingStore)this.javaContext.getValue();
        try {
            javaContext.rebind(NameParser.INSTANCE.parse(this.name), appReference, Reference.class);
        }
        catch (NamingException e) {
            throw new StartException("Failed to bind EE context: java:" + this.name, (Throwable)e);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        NamingStore javaContext = (NamingStore)this.javaContext.getValue();
        try {
            javaContext.unbind(NameParser.INSTANCE.parse(this.name));
        }
        catch (NamingException e) {
            throw new IllegalStateException("Failed to unbind EE context: java:" + this.name, e);
        }
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public Injector<NamingStore> getJavaContextInjector() {
        return this.javaContext;
    }
}

