/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.management.MBeanServer;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.InitialContextFactoryService;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingEventCoordinator;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.ObjectFactoryBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.EEContextService;
import org.jboss.as.naming.service.GlobalContextService;
import org.jboss.as.naming.service.JndiView;
import org.jboss.as.naming.service.NamingDependencyProcessor;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NamingSubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    static final NamingSubsystemAdd INSTANCE = new NamingSubsystemAdd();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        context.getSubModel().setEmptyObject();
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)context;
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    updateContext.addDeploymentProcessor(Phase.DEPENDENCIES, 2816, (DeploymentUnitProcessor)new NamingDependencyProcessor());
                    log.info((Object)"Activating Naming Subsystem");
                    ObjectFactoryBuilder.INSTANCE.setServiceRegistry(context.getServiceRegistry());
                    NamingContext.initializeNamingManager();
                    InMemoryNamingStore namingStore = new InMemoryNamingStore(new NamingEventCoordinator());
                    ServiceTarget target = context.getServiceTarget();
                    target.addService(NamingService.SERVICE_NAME, (Service)new NamingService(namingStore)).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    NamingSubsystemAdd.addGlobalContextFactory(target, "global");
                    NamingSubsystemAdd.addGlobalContextFactory(target, "jboss");
                    NamingSubsystemAdd.addContextFactory(target, "app");
                    NamingSubsystemAdd.addContextFactory(target, "module");
                    NamingSubsystemAdd.addContextFactory(target, "comp");
                    InitialContextFactoryService.addService(target);
                    JndiView jndiView = new JndiView();
                    target.addService(ServiceName.JBOSS.append(new String[]{"naming", "jndi", "view"}), (Service)jndiView).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, jndiView.getMBeanServerInjector()).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }

    private static void addContextFactory(ServiceTarget target, String contextName) {
        EEContextService eeContextService = new EEContextService(contextName);
        target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{contextName}), (Service)eeContextService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, eeContextService.getJavaContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static void addGlobalContextFactory(ServiceTarget target, String contextName) {
        GlobalContextService eeContextService = new GlobalContextService(contextName);
        target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{contextName}), (Service)eeContextService).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, eeContextService.getJavaContextInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

