/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;

public class ThreadLocalStack<E> {
    private final ThreadLocal<Deque<E>> deque = new ThreadLocal();

    public void push(E item) {
        Deque<E> st = this.deque.get();
        if (st == null) {
            st = new ArrayDeque();
            this.deque.set(st);
        }
        st.push(item);
    }

    public E peek() {
        Deque<E> st = this.deque.get();
        if (st == null) {
            return null;
        }
        return st.peek();
    }

    public E pop() {
        Deque<E> st = this.deque.get();
        if (st == null) {
            throw new EmptyStackException();
        }
        E val = st.pop();
        if (st.isEmpty()) {
            this.deque.remove();
        }
        return val;
    }
}

