/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class MemoryPoolMXBeanResetPeakUsageHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final MemoryPoolMXBeanResetPeakUsageHandler INSTANCE = new MemoryPoolMXBeanResetPeakUsageHandler();

    private MemoryPoolMXBeanResetPeakUsageHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            this.getMemoryPoolMXBean(operation).resetPeakUsage();
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return PlatformMBeanDescriptions.getDescriptionOnlyOperation(locale, "memory-pool.reset-peak-usage");
    }

    private MemoryPoolMXBean getMemoryPoolMXBean(ModelNode operation) throws OperationFailedException {
        String gcName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        MemoryPoolMXBean memoryPoolMXBean = null;
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!gcName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            memoryPoolMXBean = mbean;
        }
        if (memoryPoolMXBean == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No MemoryPoolMXBean with name %s currently exists", new Object[0])));
        }
        return memoryPoolMXBean;
    }
}

