/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.dmr.ModelNode;

public class ThreadMXBeanFindMonitorDeadlockedThreadsHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final ThreadMXBeanFindMonitorDeadlockedThreadsHandler INSTANCE = new ThreadMXBeanFindMonitorDeadlockedThreadsHandler();

    private ThreadMXBeanFindMonitorDeadlockedThreadsHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            long[] ids = ManagementFactory.getThreadMXBean().findMonitorDeadlockedThreads();
            ModelNode result = context.getResult();
            if (ids != null) {
                result.setEmptyList();
                for (long id : ids) {
                    result.add(id);
                }
            }
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return PlatformMBeanDescriptions.getFindThreadsOperation(locale, "threading.find-monitor-deadlocked-threads");
    }
}

